var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    companion         = require("app/modules/companion")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/companion/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/view/controller.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/companion/controller.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		companion.install(request.body,function(error) {
			console.log("Installed Companion: " + (!error));
			helper.apiAnswer({result:"Companion installed"},error,response);
		});
	});

router.route("/start")
	.get(function(request, response) {
		companion.start(function(error) {
			console.log("Started Companion: " + (!error));
			helper.apiAnswer({result:"Companion started"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		companion.stop(function(error) {
			console.log("Stopped Companion: " + (!error));
			helper.apiAnswer({result:"Companion stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		companion.restart(function(error) {
			console.log("Restarted Companion: " + (!error));
			helper.apiAnswer({result:"Companion restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		companion.enable(function(error) {
			console.log("Enabled Companion: " + (!error));
			helper.apiAnswer({result:"Companion enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		companion.disable(function(error) {
			console.log("Disabled Companion: " + (!error));
			helper.apiAnswer({result:"Companion disabled"},error,response);
		});
	});

router.route("/port")
	.get(function(request, response) {
		companion.get_port(function(error,result) {
			console.log("Got Companion port: " + result);
			helper.apiAnswer({port:result},error,response);
		});
	})
	.put(function(request, response) {
		companion.change_port(request.body.port,function(error) {
			console.log("Changed Companion port: " + (!error));
			helper.apiAnswer({result:(!error)},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		companion.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		companion.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		companion.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});
 
module.exports = router;