angular.module("companion", [])
	.controller("companion", ["companion", "$scope", "$location", "$interval",

    function(companion, $scope, $location, $interval) {

        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;
        $scope.port                   = 8000;

        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            companion.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion installiert: " + response.data.result);
					if (response.data.result) {
						$scope.status = "installed";
					} else {
						$scope.status = false;
					}
                } else {
                    $scope.status = false;
                }
            });
        }

        $scope.install = function() {
            $scope.status = "installing";
            companion.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion installiert: "+response.data.result);
                    $scope.status = "installed";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.start = function() {
            $scope.status = "starting";
            companion.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion gestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.stop = function() {
            $scope.status = "stopping";
            companion.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.restart = function() {
            $scope.status = "restarting";
            companion.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion neugestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "restarted";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            companion.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            companion.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.set_port = function() {
            companion.set_port({port:$scope.port}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Port geändert: " + response.data.result);
                }
            });
        }

        $scope.get_port = function() {
            companion.get_port().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.port = response.data.port;
                }
            });
        }

        $scope.is_enabled = function() {
            companion.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            companion.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.is_installed();
        $scope.is_enabled();
        $scope.is_active();
        $scope.get_port();
        $interval(function() {
            $scope.is_installed();
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);