angular.module("companion_satellite", [])
	.controller("companion_satellite", ["companion_satellite", "$scope", "$location", "$interval",

    function(companion_satellite, $scope, $location, $interval) {

        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;
        $scope.ip_address             = '';

        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            companion_satellite.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Satellite installiert: " + response.data.result);
					if (response.data.result) {
						$scope.status = "installed";
					} else {
						$scope.status = false;
					}
                } else {
                    $scope.status = false;
                }
            });
        }

        $scope.install = function() {
            $scope.status = "installing";
            companion_satellite.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Satellite installiert: "+response.data.result);
                    $scope.status = "installed";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.start = function() {
            $scope.status = "starting";
            companion_satellite.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Satellite gestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.stop = function() {
            $scope.status = "stopping";
            companion_satellite.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Satellite gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.restart = function() {
            $scope.status = "restarting";
            companion_satellite.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Satellite neugestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "restarted";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            companion_satellite.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Satellite aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            companion_satellite.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Satellite deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.set_ip_address = function() {
            companion_satellite.set_ip_address({ip_address:$scope.ip_address}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Companion Satellite IP-Addresse geändert: " + response.data.result);
                }
            });
        }

        $scope.get_ip_address = function() {
            companion_satellite.get_ip_address().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.ip_address = response.data.ip_address;
                }
            });
        }

        $scope.is_enabled = function() {
            companion_satellite.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            companion_satellite.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.is_installed();
        $scope.is_enabled();
        $scope.is_active();
        $scope.get_ip_address();
        $interval(function() {
            $scope.is_installed();
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);