var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    lcdshow           = require("app/modules/lcdshow")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/lcdshow/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/view/controller.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/lcdshow/controller.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		lcdshow.install(function(error) {
			console.log("Installed LCD-show: " + (!error));
			helper.apiAnswer({result:"LCD-show installed"},error,response);
		});
	});

router.route("/enable")
	.post(function(request, response) {
		lcdshow.enable(request.body.mode,function(error) {
			console.log("Enabled LCD-show: " + (!error));
			helper.apiAnswer({result:"LCD-show enabled"},error,response);
		});
	});

router.route("/disable")
	.post(function(request, response) {
		lcdshow.disable(function(error) {
			console.log("Disabled LCD-show: " + (!error));
			helper.apiAnswer({result:"LCD-show disabled"},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		lcdshow.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		lcdshow.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/modes")
	.get(function(request, response) {
		lcdshow.get_modes(function(error,result) {
			if ( !error && result ) {
				console.log("Got LCD-show modes:", result);
			}
			helper.apiAnswer({modes:result},error,response);
		});
	});

module.exports = router;