var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    openslides        = require("app/modules/openslides")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/openslides/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/view/controller.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/openslides/controller.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		openslides.install(request.body,function(error) {
			console.log("Installed OpenSlides: " + (!error));
			helper.apiAnswer({result:"OpenSlides installed"},error,response);
		});
	});

router.route("/start")
	.get(function(request, response) {
		openslides.start(function(error) {
			console.log("Started OpenSlides: " + (!error));
			helper.apiAnswer({result:"OpenSlides started"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		openslides.stop(function(error) {
			console.log("Stopped OpenSlides: " + (!error));
			helper.apiAnswer({result:"OpenSlides stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		openslides.restart(function(error) {
			console.log("Restarted OpenSlides: " + (!error));
			helper.apiAnswer({result:"OpenSlides restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		openslides.enable(function(error) {
			console.log("Enabled OpenSlides: " + (!error));
			helper.apiAnswer({result:"OpenSlides enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		openslides.disable(function(error) {
			console.log("Disabled OpenSlides: " + (!error));
			helper.apiAnswer({result:"OpenSlides disabled"},error,response);
		});
	});

router.route("/port")
	.get(function(request, response) {
		openslides.get_port(function(error,result) {
			console.log("Got OpenSlides port: " + result);
			helper.apiAnswer({port:result},error,response);
		});
	})
	.put(function(request, response) {
		openslides.change_port(request.body.port,function(error) {
			console.log("Changed OpenSlides port: " + (!error));
			helper.apiAnswer({result:(!error)},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		openslides.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		openslides.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		openslides.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

module.exports = router;