var async           = require("async"),
    fs              = require("fs-extra"),
    exec            = require("child_process").exec,
    systemctl       = require("systemctl-cmd"),
    apt             = require("apt"),
    config          = require("app/core/config")();

/*****************************************************************************\
    Return a set of functions which we can use to install and
    control components
\*****************************************************************************/
module.exports = function() {

    var _install = function(callback) {
        console.log("= Installing rpi_touch_driver =");

        async.waterfall([
            function install_dependencies(next_step) {
                console.log('Installing dependencies...');
                apt.install('git', function(error) {
                    if (!error) console.log("Dependencies installed successfully...");
                    next_step(error);
                });
            },
            function reload_config(next_step) {
                console.log("Reloading config...");
                config.load(function(error, data) {
                    if (!error) {
                        config = data;
                        console.log("Reloaded config successfully");
                    }
                    next_step(error);
                });
            },
            function cloning_git_repo(next_step) {
                console.log("Cloning git repo...");
                exec(`cd /home/pi && git clone https://github.com/bsteinsbo/rpi_touch_driver`, function(error, stdout, stderr) {
                    if (!error) console.log("Cloned git repo successfully");
                    next_step(error);
                });
            },
            function make(next_step) {
                console.log("make...");
                exec(`cd /home/pi/rpi_touch_driver && make`, function(error, stdout, stderr) {
                    if (!error) console.log("make was successfully");
                    next_step(error);
                })
            },
            function install(next_step) {
                console.log("install...");
                exec(`cd /home/pi/rpi_touch_driver && sudo make install`, function(error, stdout, stderr) {
                    if (!error) console.log("install was successfully");
                    next_step(error);
                })
            },
            function install_service(next_step) {
                console.log("install...");
                exec(`cd /home/pi/rpi_touch_driver && sudo make systemd-install`, function(error, stdout, stderr) {
                    if (!error) console.log("systemd-install was successfully");
                    next_step(error);
                })
            },
            function save_config(next_step) {
                console.log(`Saving config...`);
                if (!config.modules) config.modules = {};
                config.modules.rpi_touch_driver = true;
                if (!config.rpi_touch_driver) config.rpi_touch_driver = {};
                config.rpi_touch_driver.installed = true;
                config.save(config, function(error) {
                    if (!error) console.log(`Saved config successfully`);
                    next_step(error);
                });
            }
        ], callback);
    };

    var _start = function(callback) {
        console.log('Start service...');
        systemctl.start('rpi_touch_driver',true).then(result => {
            if (result.error) callback(result.error)
            else {
                console.log("Service started successfully...");
                callback();
            }
        })
    };

    var _stop = function(callback) {
        console.log('Stop service...');
        systemctl.stop('rpi_touch_driver',true).then(result => {
            if (!result.error) console.log("Service stopped successfully...");
            callback(result.error);
        })
    };

    var _restart = function(callback) {
        console.log('Restarting service...');
        systemctl.restart('rpi_touch_driver',true).then(result => {
            if (result.error) callback(result.error)
            else {
                console.log("Service restarted successfully...");
                callback();
            }
        })
    };

    var _enable = function(callback) {
        console.log('Enable service...');
        systemctl.enable('rpi-touch-driver',true).then(result => {
            if (!result.error) console.log("Service enabled successfully...");
            callback(result.error);
        })
    };

    var _disable = function(callback) {
        console.log('Disable service...');
        systemctl.disable('rpi-touch-driver',true).then(result => {
            if (!result.error) console.log("Service disabled successfully...");
            callback(result.error);
        })
    };

    var _is_installed = function(callback) {
        fs.pathExists('/etc/systemd/system/rpi-touch-driver.service', callback);
    };

    var _is_enabled = function(callback) {
        systemctl.isEnabled('rpi-touch-driver').then(enabled => {
            callback(null, enabled);
        }, error => {
            callback(error);
        })
    };

    var _is_active = function(callback) {
        systemctl.isActive('rpi-touch-driver').then(active => {
            callback(null, active);
        }, error => {
            callback(error);
        })
    };

    return {
        install:                    _install,
        enable:                     _enable,
        disable:                    _disable,
        start:                      _start,
        stop:                       _stop,
        restart:                    _restart,
        is_installed:               _is_installed,
        is_enabled:                 _is_enabled,
        is_active:                  _is_active,
    };
}