var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    vnc               = require("app/modules/vnc")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/vnc/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/view/controller.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/vnc/controller.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		vnc.install(request.body,function(error) {
			console.log("Installed VNC: " + (!error));
			helper.apiAnswer({result:"VNC installed"},error,response);
		});
	});

router.route("/start")
	.get(function(request, response) {
		vnc.start(function(error) {
			console.log("Started VNC: " + (!error));
			helper.apiAnswer({result:"VNC started"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		vnc.stop(function(error) {
			console.log("Stopped VNC: " + (!error));
			helper.apiAnswer({result:"VNC stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		vnc.restart(function(error) {
			console.log("Restarted VNC: " + (!error));
			helper.apiAnswer({result:"VNC restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		vnc.enable(function(error) {
			console.log("Enabled VNC: " + (!error));
			helper.apiAnswer({result:"VNC enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		vnc.disable(function(error) {
			console.log("Disabled VNC: " + (!error));
			helper.apiAnswer({result:"VNC disabled"},error,response);
		});
	});

router.route("/port")
	.get(function(request, response) {
		vnc.get_port(function(error,result) {
			console.log("Got VNC port: " + result);
			helper.apiAnswer({port:result},error,response);
		});
	})
	.put(function(request, response) {
		vnc.set_port(request.body.port,function(error) {
			console.log("Changed VNC port: " + (!error));
			helper.apiAnswer({result:(!error)},error,response);
		});
	});

router.route("/passwd")
	.get(function(request, response) {
		vnc.get_passwd(function(error,result) {
			console.log("Got VNC passwd: " + result);
			helper.apiAnswer({passwd:result},error,response);
		});
	})
	.put(function(request, response) {
		vnc.set_passwd(request.body.passwd,function(error) {
			console.log("Changed VNC passwd: " + (!error));
			helper.apiAnswer({result:(!error)},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		vnc.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		vnc.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		vnc.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});
 
module.exports = router;