app.controller("audio", ["audio", "$scope", "$location", "$interval",

    function(audio, $scope, $location, $interval) {

        $scope.selected_output        = '0';
        $scope.default_output         = '';
        $scope.soundcard              = 'default';
        $scope.soundcards             = {};
        $scope.scontrols              = {};
        $scope.mode                   = 'playback';

		$scope.getSoundcards = function() {
            audio.get_soundcards().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.soundcards = response.data.soundcards;
                }
            });
		}
		
		$scope.getControls = function() {
			var soundcard = ($scope.soundcard=='default')?null:$scope.soundcard;
            audio.get_simple_controls(soundcard).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.scontrols = response.data.scontrols;
                }
            });
		}
		
		$scope.setControl = function(name, values) {
			var soundcard = ($scope.soundcard=='default')?null:$scope.soundcard;
            audio.set_simple_control(soundcard, name, values).then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.getControls();
                }
            });
		}

		$scope.getDefaultOutput = function() {
            audio.get_default_output().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.default_output = response.data.default_output;
                    $scope.selected_output = response.data.default_output.cardNumber;
                }
            });
		}
		
		$scope.setDefaultOutput = function() {
            audio.set_default_output($scope.selected_output).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.default_output = response.data.default_output;
                    $scope.selected_output = response.data.default_output.cardNumber;
                }
            });
		}
		
		$scope.getSoundcards();
		$scope.getControls();
		$scope.getDefaultOutput();
        $interval(function() {
			$scope.getDefaultOutput();
        }, 5000);

    }]
);
