app.controller("hotspot", ["hotspot", "$scope", "$location", "$interval",

    function(hotspot, $scope, $location, $interval) {

        $scope.ssid                   = "PiratenBox";
        $scope.passphrase             = "PiratenBoxInstaller";
        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;

        $scope.start = function() {
            $scope.status = "starting";
            hotspot.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Hotspot gestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.stop = function() {
            $scope.status = "stopping";
            hotspot.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Hotspot gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            hotspot.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Hotspot aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            hotspot.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Hotspot deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.is_enabled = function() {
            hotspot.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            hotspot.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.get_ssid = function() {
            hotspot.get_ssid().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.url = response.data.ssid;
                }
            });
        }

        $scope.set_ssid = function() {
            hotspot.set_ssid({ssid:$scope.ssid}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Hotspot SSID geändert: " + response.data.result);
                }
            });
        }

        $scope.get_passphrase = function() {
            hotspot.get_passphrase().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.url = response.data.ssid;
                }
            });
        }

        $scope.set_passphrase = function() {
            hotspot.set_passphrase({passphrase:$scope.passphrase}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Hotspot Passphrase geändert: " + response.data.result);
                }
            });
        }

        $scope.is_enabled();
        $scope.is_active();
        $scope.get_ssid();
        $scope.get_passphrase();
        $interval(function() {
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);
