app.controller("screen", ["screen", "$scope", "$location", "$interval", "$timeout",

    function(screen, $scope, $location, $interval, $timeout) {
        // Scope variable declaration
        // screen
        $scope.status                    = false;
        $scope.blanking                  = false;
        $scope.overscan                  = false;
        $scope.monitors                  = {};
        $scope.monitor_count             = 0;
        $scope.screen                    = {
			selected_monitor: '',
			primary_monitor: '',
			current_resolution: '',
			selected_resolution: ''
		};

        $scope.is_on = function() {
            screen.is_on().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Screen is: ", response.data.result);
                    if (response.data.result.monitor=='on' && response.data.result.blanking=='no') {
                        $scope.status = true;
                    } else if (response.data.result.monitor=='' && response.data.result.blanking=='no') {
                        $scope.status = 'kiosk';
                    } else if (response.data.result.monitor=='' && response.data.result.blanking=='') {
                        $scope.status = 'unknown';
                    } else {
                        $scope.status = false;
                    }
                }
            });
        }


        $scope.get_blanking = function() {
            screen.get_blanking().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.blanking = response.data.blanking;
                }
            });
        }

        $scope.enable_blanking = function() {
            screen.set_blanking(true).then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.blanking = response.data.blanking;
                }
            });
        }

        $scope.disable_blanking = function() {
            screen.set_blanking(false).then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.blanking = response.data.blanking;
                }
            });
        }


        $scope.get_overscan = function() {
            screen.get_overscan().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.overscan = response.data.overscan;
                }
            });
        }

        $scope.enable_overscan = function() {
            screen.set_overscan(true).then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.overscan = response.data.overscan;
                }
            });
        }

        $scope.disable_overscan = function() {
            screen.set_overscan(false).then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.overscan = response.data.overscan;
                }
            });
        }


        $scope.load_monitor = function() {
			console.log('screen.selected_monitor', $scope.screen.selected_monitor);
			if ($scope.screen.selected_monitor) {
				$scope.monitors[$scope.screen.selected_monitor].modes.forEach(function(mode){
					if( mode.current ) {
						$scope.screen.current_resolution = mode.width+'x'+mode.height+((mode.interlaced)?'i':'');
						$('#'+$scope.screen.selected_monitor+'-panel #inputResolution').val($scope.screen.current_resolution);
						if ( !$scope.screen.selected_resolution ) {
							$scope.screen.selected_resolution = $scope.screen.current_resolution;
						}
						return;
					}
				});
			} else {
				console.log('failed loading: "'+$scope.screen.selected_monitor+'"');
			}
        }

        $scope.select_resolution = function() {
			$scope.screen.selected_resolution = $('#'+$scope.screen.selected_monitor+'-panel #inputResolution').val();
        }

        $scope.get_monitors = function() {
            screen.get_monitors().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.monitors = response.data.monitors;
					console.log("Monitors: ", $scope.monitors);
					for (const name in $scope.monitors) {
						if ($scope.monitors[name].primary) {
							$scope.screen.primary_monitor = name;
							break;
						}
					};
					$scope.monitor_count = Object.keys(response.data.monitors).length;
					if ( $scope.screen.selected_monitor == '' ) {
						$scope.screen.selected_monitor = $scope.screen.primary_monitor;
						$scope.load_monitor();
					}
                }
            });
        }
		
		$scope.set_monitor_on = function() {
            screen.set_monitor_on($scope.screen.selected_monitor).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Turn monitor on result: " + response.data.result);
					$scope.screen.selected_resolution = '';
					$scope.monitors[$scope.screen.selected_monitor] = response.data.monitor;
					$scope.load_monitor($scope.screen.selected_monitor);
                }
            });
        }

        $scope.set_monitor_off = function() {
            screen.set_monitor_off($scope.screen.selected_monitor).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Turn monitor off result: "+response.data.result);
                    $scope.status = false;
					$scope.monitors[$scope.screen.selected_monitor].modes = [];
					$scope.screen.selected_resolution = '';
                }
            });
        }

        $scope.set_monitor_resolution = function() {
            screen.set_monitor_resolution($scope.screen.selected_monitor, $scope.screen.selected_resolution).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Set monitor resolution result: "+response.data.result);
                    $scope.get_monitors();
                }
            });
        }

        $scope.set_monitor_rotation = function(rotation) {
            screen.set_monitor_rotation($scope.screen.selected_monitor, rotation).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Set monitor rotation result: "+response.data.result);
                    $scope.get_monitors();
                }
            });
        }

        $scope.set_monitor_position = function(position) {
            screen.set_monitor_position($scope.screen.selected_monitor, position).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Set monitor position result: "+response.data.result);
                    $scope.get_monitors();
                }
            });
        }

        $scope.set_monitor_primary = function() {
            screen.set_monitor_primary($scope.screen.selected_monitor).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Set monitor to primary result: " + response.data.result);
                    $scope.get_monitors();
                }
            });
        }



        // Defer load the states and infos
        $scope.is_on();
        $scope.get_blanking();
        $scope.get_overscan();
        $scope.get_monitors();
        $interval(function() {
            $scope.is_on();
//            $scope.get_monitors();
        }, 5000);

    }]
);