app.controller("SetupController", ["core", "wifi", "system", "$scope", "$location", "$http",

    function(core, wifi, system, $scope, $location, $http) {
        // Scope variable declaration
        // main view
        $scope.current_tab               = "welcome";
        $scope.logdata                   = "";
        $scope.pool                      = null;
        $scope.finished                  = false;
        $scope.hostname                  = '';
        // system update
        $scope.updates_status            = true;
        // Network configuration
        $scope.wifi_exists               = false;
        $scope.wifi_connect              = false;
        $scope.scan_results              = [];
        $scope.selected_cell             = null;
        $scope.scan_running              = false;
        $scope.connected                 = false;
        $scope.connected_cell            = null;
        $scope.network_passcode          = "";
        $scope.show_passprompt            = false;
        $scope.ping_status               = "unchecked";
        $scope.current_host              = $location.host();
        $scope.lan_ip                    = "";
        $scope.wifi_ip                   = "";
        // module installations
        $scope.akk_status                = false;
        $scope.companion_status          = false;
        $scope.companion_satellite_status= false;
        $scope.openslides_status         = false;
        $scope.kiosk_status              = false;
        $scope.screenstream_status       = false;
        // touch driver installations
        $scope.lcdshow_status            = false;
        $scope.rpi_touch_driver_status   = false;
        // feature configurations
        $scope.hotspot_status            = false;

        $scope.log = function(message) {
			console.log(message);
			$scope.logdata = $scope.logdata + "<br />" + message;
        }

        // Scope filter definitions
        $scope.orderScanResults = function(cell) {
            return parseInt(cell.signal_strength);
        }

        // Scope function definitions
        $scope.wlan0_exists = function() {
            wifi.wlan0_exists().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.wifi_exists = response.data.exists;
                }
            });
        }

        $scope.rescan = function() {
            $scope.scan_results = [];
            $scope.scan_running = true;
            wifi.rescan_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.scan_results = response.data.scan_results;
                }
                $scope.scan_running = false;
            });
        }

        $scope.change_selection = function(cell) {
            $scope.network_passcode = "";
            $scope.selected_cell = cell;
            $scope.show_passprompt = (cell != null) ? true : false;
        }

        $scope.submit_selection = function() {
            $scope.show_passprompt = false;
            $scope.current_tab = 'finish';
			$scope.connect_wifi(function(){
				$scope.run_setup();
			});
        }

        $scope.connect_wifi = function(callback) {
            if ($scope.selected_cell && $scope.selected_cell["ssid"]) {
                var wifi_info = {
                    wifi_ssid: $scope.selected_cell["ssid"],
                    wifi_passcode: $scope.network_passcode
                };
                wifi.enable_wifi(wifi_info).then(function(response) {
                    if (response.data.status == "SUCCESS") {
                        console.log("WiFi Enabled - nothing left to do...");
                        $scope.connected = true;
                        $scope.connected_cell = {
                            "ssid": $scope.selected_cell["ssid"],
                            "address": $scope.selected_cell["address"]
                        };
                        callback();
                    } else {
                        $scope.connected = false;
                        $scope.connected_cell = null;
                        callback();
                    }
                }, function() {
                    callback();
                });
            } else {
                callback();
            }
        }

        $scope.update_wifi_info = function() {
            wifi.get_wifi_info().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WIFI SSID: "+response.data.ap_ssid);
                    console.log("WIFI AP Address: "+response.data.ap_addr);
                    $scope.connected_cell = {
                        "ssid": response.data.ap_ssid,
                        "address": response.data.ap_addr
                    };
                    $scope.selected_cell = $scope.connected_cell;
                }
            });
        }

        $scope.is_wifi_enabled = function() {
            wifi.is_wifi_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    if (response.data.connected && response.data.address != '192.168.42.1') {
                        console.log("WIFI is Connected");
                        console.log("WIFI IPv4: " + response.data.address);
                        $scope.connected = true;
                        $scope.wifi_ip = response.data.address;
                        $scope.update_wifi_info();
                    } else {
                        console.log("WIFI is not Connected");
                        if (!$scope.lan_ip) {
                            $scope.connected = false;
                        }
                    }
                }
            });
        }

        $scope.get_remote_info = function(hostname, callback) {
            return new Promise(function(resolve, reject) {
                core.get_infos(hostname).then(function(response) {
                    if (response.data.status == "SUCCESS") {
                        if (callback) callback(response.data.infos);
                        resolve(response.data.infos);
                    } else {
                        resolve();
                    }
                },function(){
                    resolve();
                });
            });
        }

        $scope.is_lan_connected = function() {
            system.is_lan_connected().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    if (response.data.connected) {
                        console.log("LAN is Connected");
                        console.log("LAN IPv4: " + response.data.address);
                        $scope.connected = true;
                        $scope.lan_ip = response.data.address;
                    } else {
                        console.log("LAN is not Connected");
                        if (!$scope.wifi_ip) {
                            $scope.connected = false;
                        }
                    }
                }
            });
        }


		$scope.scan_port = function (host, port, timeout) {
            return new Promise(function(resolve, reject) {
				var port = (!port)?443:port;
				var timeout = (!timeout)?1000:timeout;
				var img = new Image();

				img.onerror = function () {
					if (!img) return;
					img = undefined;
					resolve(host);
				};

				img.onload = img.onerror;
				img.src = 'http://' + host + ':' + port;

				setTimeout(function () {
					if (!img) return;
					img = undefined;
					reject();
				}, timeout);
            });
		}

        $scope.check_subnets = function(subnet_prefix, callback) {
            $scope.ping_status = "searching";
            var found_subnet = null;
            var maxConnections = 10;

            $scope.pool = new PromisePool(function * () {
                for (let i = 0; i < 255; i++) {
                    $scope.log("Checking subnet " + subnet_prefix + i);
                    yield $scope.scan_port(subnet_prefix + i + ".1")
                }
            }, maxConnections)

            $scope.pool.addEventListener('fulfilled', (event) => {
                if (event.data.result) {
                    found_subnet = event.data.result;
					callback(found_subnet);
//                    $scope.pool._settle();
                }
            })

            $scope.pool.start().then(() => {
                callback();
            },(error) => {
//                callback()
            })

        }


        $scope.check_hosts = function(subnet_prefix, callback) {
            $scope.ping_status = "searching";
            var found_device = null;
            var maxConnections = 10;

            $scope.pool = new PromisePool(function * () {
                for (let i = 1; i < 255; i++) {
//                    console.log("Checking " + subnet_prefix + i);
                    yield $scope.get_remote_info(subnet_prefix + i)
                }
            }, maxConnections)

            $scope.pool.addEventListener('fulfilled', (event) => {
                if (event.data.result) {
                    found_device = event.data.result;
					callback(found_device);
//                    $scope.pool._settle();
                }
            })

            $scope.pool.start().then(() => {
                callback()
            },(error) => {
//                callback()
            })
        }


        $scope.search_raspberry = function(callback) {
            if ( $scope.lan_ip != $scope.current_host && $scope.selected_cell && $scope.selected_cell["ssid"]) {
                $scope.get_remote_info( $scope.hostname + ".local", function(device_info) {
                    if (device_info) {
                        $scope.log("New WIFI Address: " + device_info.wifi_ip);
                        $scope.current_host = device_info.wifi_ip;
                        $scope.ping_status = "alive";
                        callback();
                    } else {
						// TODO: Also check 10.0.0.0 – 10.255.255.255 and 172.16.0.0 – 172.31.255.255
                        $scope.log("Could not resolve with mDNS");
						$scope.log("Checking subnets in 192.168.");
						$scope.check_subnets('192.168.', function(found_routerip) {
							if (found_routerip) {
								$scope.log("Found router ip: " + found_routerip);
								subnet_prefix = found_routerip.substring(0, found_routerip.length - 1);
								$scope.log("Searching in subnet " + subnet_prefix);
								$scope.check_hosts(subnet_prefix, function(device_info) {
									if (device_info.hostname == $scope.hostname) {
										$scope.pool._settle();
										$scope.log("Found PiratenBox: " + device_info.wifi_ip);
										$scope.current_host = device_info.wifi_ip;
										$scope.ping_status = "alive";
										callback();
									} else {
										$scope.log("Cound not find a PiratenBox in subnet " + subnet_prefix);
//										$scope.ping_status = "failed";
//										callback();
									}
								});
							} else {
								$scope.log("Cound not find an available	subnet");
//								$scope.ping_status = "failed";
//								callback();
							}
						});
                    }
                });
            } else {
                callback();
            }

        }


        $scope.install_updates = function(callback) {
            if ($scope.updates_status==true) {
                $scope.updates_status = "installing";
                system.install_updates().then(function(response) {
                    if (response.data.status == "SUCCESS") {
                        console.log("Updates installed: "+response.data.result);
                        $scope.updates_status = "installed";
                        callback();
                    } else {
                        $scope.updates_status = "failed";
                        callback();
                    }
                }, function() {
                    $scope.updates_status = "failed";
                    callback();
                });
            } else {
                callback();
            }
        }

        $scope.install_module = function(name, slug, callback) {
            if ($scope[slug+'_status'] == true) {
                $scope[slug+'_status'] = "installing";
				var url = "http://" + $location.host() + ":4242/api/" + slug + "/install";
                $http.post(url, {})
					.then(function(response) {
						if (response.data.status == "SUCCESS") {
							console.log(name+" installed: "+response.data.result);
							$scope[slug+'_status'] = "installed";
							callback();
						} else {
							$scope[slug+'_status'] = "failed";
							callback();
						}
					}, function() {
						$scope[slug+'_status'] = "failed";
						callback();
					});
            } else {
                callback();
            }
        }

        $scope.run_setup = function() {
			$scope.search_raspberry(function() {
				$scope.install_updates(function() {
					$scope.install_module('Akk-Tool','akk',function() {
						$scope.install_module('Companion','companion',function() {
							$scope.install_module('Companion Satellite','companion_satellite',function() {
								$scope.install_module('OpenSlides','openslides',function() {
									$scope.install_module('Kiosk','kiosk',function() {
										$scope.install_module('Screenstream','screenstream',function() {
											$scope.install_module('LCD-show','lcdshow',function() {
												$scope.install_module('rpi_touch_driver','companion',function() {
													$scope.finished = true;
													console.log('Fertig');
												});
											});
										});
									});
								});
							});
						});
					});
				});
			});
        }


        // Defer load the states and infos
        $scope.wlan0_exists();
        $scope.is_wifi_enabled();
        $scope.is_lan_connected();
        $scope.rescan();
		$scope.get_remote_info($scope.current_host, function(device_info){
			$scope.hostname = device_info.hostname;
		});

    }]
);
