app.controller("system", ["system", "$scope", "$interval",

    function(system, $scope, $interval) {

        $scope.hostname                  = "";
        $scope.password                  = "";
        $scope.shutdown_status           = true;
        $scope.reboot_status             = true;
        $scope.updates_status            = true;
        $scope.locale                    = {'selected': '',
											'active': '',
											'installed': [],
											'supported': []};

        $scope.get_hostname = function() {
            system.get_hostname().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log(response.data);
                    if (response.data.hostname) {
                        $scope.hostname = response.data.hostname;
                    }
                }
            });
        }

        $scope.change_hostname = function() {
            system.set_hostname($scope.hostname).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log(response.data);
                    $scope.get_hostname();
                }
            });
        }

        $scope.get_locales = function() {
            system.get_locales().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log(response.data);
                    if (response.data.locales) {
                        $scope.locale.installed = response.data.locales.installed;
                        $scope.locale.supported = response.data.locales.supported;
                    }
                }
            });
        }

        $scope.get_locale = function() {
            system.get_locale().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log(response.data);
                    if (response.data.locale) {
						if ($scope.locale.selected == "" || $scope.locale.selected == $scope.locale.installed) {
							$scope.locale.selected = response.data.locale;
						}
                        $scope.locale.active = response.data.locale;
                    }
                }
            });
        }

        $scope.set_locale = function() {
			console.log('set_locale: ' + $scope.locale.selected);
            system.set_locale($scope.locale.selected).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log(response.data);
                    $scope.get_locale();
                }
            });
        }

        $scope.set_keyboard = function() {
			console.log('set_keyboard: ' + $scope.keyboard.selected);
            system.set_keyboard($scope.keyboard.selected).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log(response.data);
//                    $scope.get_keyboard();
                }
            });
        }

        $scope.change_password = function() {
            system.change_password($scope.password).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Changed password");
                    $scope.password = "";
                }
            });
        }

        $scope.shutdown = function() {
            $scope.shutdown_status = "shuttingdown";
            system.shutdown().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Shutdown started: " + response.data.result);
                    $scope.shutdown_status = "shutdown";
                } else {
                    $scope.shutdown_status = "failed";
                }
            });
        }

        $scope.reboot = function() {
            $scope.reboot_status = "rebooting";
            system.reboot().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Reboot started: " + response.data.result);
                    $scope.reboot_status = "rebooted";
                } else {
                    $scope.reboot_status = "failed";
                }
            });
        }

        $scope.install_updates = function() {
            $scope.updates_status = "installing";
            system.install_updates().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Updates installed: "+response.data.result);
                    $scope.updates_status = "installed";
                } else {
                    $scope.updates_status = "failed";
                }
            });
        }


        // Defer load the states and infos
        $scope.get_hostname();
        $scope.get_locale();
        $scope.get_locales();
        $interval(function() {
			$scope.get_locale();
			$scope.get_locales();
        }, 5000);

    }]
);