"use strict";

app.service("screenstream", ["$http", "$location",

    function($http, $location) {
        return {

            is_installed: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/is_installed");
            },
            install: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/install");
            },
            start: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/start");
            },
            stop: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/stop");
            },
            restart: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/restart");
            },
            enable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/enable");
            },
            disable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/disable");
            },
            is_active: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/is_active");
            },
            is_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/is_enabled");
            },
            change_url: function(url, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screenstream/change_url", url);
            },
            get_url: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screenstream/get_url");
            },

        };
    }]

);