var express           = require('express'),
    router            = express.Router(),
    screen            = require("app/core/screen")(),
    helper            = require("app/core/helper");

router.route("/on")
	.get(function(request, response) {
		screen.is_on(function(error, result) {
//        console.log("Checked if screen is on: " + (!error));
//        console.log("Monitor is: " + (result.monitor));
//        console.log("Blanking is: " + (result.blanking));
			helper.apiAnswer({result:result},error,response);
		});
	})
	.post(function(request, response) {
		screen.set_on(function(error, result) {
			console.log("Turned screen on: " + (!error));
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/off")
    .post(function(request, response) {
		screen.set_off(function(error, result) {
			console.log("Turned screen off: " + (!error));
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/monitor/on")
    .post(function(request, response) {
		screen.set_monitor_on(request.body.monitor,function(error, result) {
			console.log("Turned monitor on: " + (!error));
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/monitor/off")
    .post(function(request, response) {
		screen.set_monitor_off(request.body.monitor, function(error, result) {
			console.log("Turned monitor off: " + (!error));
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/monitor/resolution")
    .post(function(request, response) {
		screen.set_monitor_resolution(request.body.monitor, request.body.resolution, function(error, result) {
			console.log("Set resolution of monitor: " + (!error));
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/monitor/rotation")
    .post(function(request, response) {
		screen.set_monitor_rotation(request.body.monitor, request.body.rotation, function(error, result) {
			console.log("Set rotation of monitor: " + (!error));
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/monitor/position")
    .post(function(request, response) {
		screen.set_monitor_position(request.body.monitor, request.body.position, function(error, result) {
			console.log("Set position of monitor: " + (!error));
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/monitor/primary")
    .post(function(request, response) {
		screen.set_monitor_primary(request.body.monitor, function(error, result) {
			console.log("Set monitor to primary: " + (!error));
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/monitors")
    .get(function(request, response) {
		screen.get_monitors(function(error, result) {
			helper.apiAnswer({monitors:result},error,response);
		});
	});

router.route("/blanking")
	.get(function(request, response) {
		screen.get_overscan(function(error, result) {
			helper.apiAnswer({blanking:result},error,response);
		});
	})
	.post(function(request, response) {
		screen.set_overscan(request.body.blanking,function(error) {
			console.log("Set blanking: " + (!error));
			helper.apiAnswer({result:"Blanking set"},error,response);
		});
	});

router.route("/overscan")
	.get(function(request, response) {
		screen.get_overscan(function(error, result) {
			helper.apiAnswer({overscan:result},error,response);
		});
	})
	.post(function(request, response) {
		screen.set_overscan(request.body.overscan,function(error) {
			console.log("Set Overscan: " + (!error));
			helper.apiAnswer({result:"Overscan set"},error,response);
		});
	});

module.exports = router;