var express           = require('express'),
    router            = express.Router(),
    si                = require('systeminformation'),
    system            = require("app/core/system")(),
    helper            = require("app/core/helper");

router.route("/shutdown")
	.get(function(request, response) {
		console.log('GET: shutdown');
		system.shutdown(function(error) {
			console.log("Shutdown started: " + (!error));
			helper.apiAnswer({result:"Shutdown started"},error,response);
		});
	});

router.route("/reboot")
	.get(function(request, response) {
		console.log('GET: reboot');
		system.reboot(function(error) {
			console.log("Reboot started: " + (!error));
			helper.apiAnswer({result:"Reboot started"},error,response);
		});
	});

router.route("/autoupdate")
	.get(function(request, response) {
		console.log('GET: autoupdate');
		system.autoupdate(function(error) {
			console.log("Autoupdate: " + (!error));
			helper.apiAnswer({result:"Autoupdate started"},error,response);
		});
	});

router.route("/lan_connected")
	.get(function(request, response) {
//        console.log("GET: /lan_connected");
		system.get_lan_info(function(error,result) {
			let response_obj = {connected:(result.inet_addr !== "<unknown>"), address:result.inet_addr};
			helper.apiAnswer(response_obj,error,response);
		})
	});

router.route("/locales")
	.get(function(request, response) {
		console.log('GET: locale');
		system.get_locales(function(error,result) {
			console.log("Got locales: " + (!error));
			helper.apiAnswer({"locales": result},error,response);
		});
	});

router.route("/locale")
	.get(function(request, response) {
		console.log('GET: locale');
		system.get_locale(function(error,result) {
			console.log("Got locale: " + (!error));
			helper.apiAnswer({"locale": result},error,response);
		});
	})
	.post(function(request, response) {
		console.log('POST: locale');
		system.set_locale(request.body,function(error) {
			console.log("Set locale: " + (!error));
			helper.apiAnswer({result:"Locale set"},error,response);
		});
	});

router.route("/keyboard")
	.get(function(request, response) {
		console.log('GET: keyboard');
		system.get_keyboard(function(error,result) {
			console.log("Got keyboard: " + (!error));
			helper.apiAnswer({"keyboard": result},error,response);
		});
	})
	.post(function(request, response) {
		console.log('POST: keyboard');
		system.set_keyboard(request.body,function(error) {
			console.log("Set keyboard: " + (!error));
			helper.apiAnswer({result:"keyboard set"},error,response);
		});
	});


router.route("/temperature")
	.get(function(request, response) {
		console.log('GET: temperature');
		system.get_temperature(function(error,result) {
			console.log("Got temperature: " + (!error));
			helper.apiAnswer({"temperature": result},error,response);
		});
	});


// Return hw infos on this computer
router.route('/hw_infos')
	.get(function (req, res) {
		Promise.all([si.cpu(),si.graphics(),si.osInfo()]).then( (values) => {
			var output = {};
			output.cpu = values[0];
			output.graphics = values[1].controllers;
			output.os = values[2];
			res.send(output);
		})
		.catch( (err) => {
			res.status(500);
			res.send(err);
		});
	});

// Return load infos on this computer
router.route('/load_infos')
	.get(function (req, res) {
		si.currentLoad().then( (values) => {
			res.send(values);
		})
		.catch( (err) => {
			res.status(500);
			res.send(err);
		});
	});


router.route('/hostname')
	.get(function (request, response) {
		system.get_hostname(function(error, result) {
			console.log("Got hostname: " + (!error));
			helper.apiAnswer({"hostname": result},error,response);
		});
	})
	.post(function (request, response) {
		system.set_hostname(request.body,function(error) {
			console.log("Set hostname: " + (!error));
			helper.apiAnswer({result:"Hostname set"},error,response);
		});
	});

router.route('/passwd')
	.post(function (request, response) {
		system.change_password(request.body,function(error) {
			console.log("Changed password: " + (!error));
			helper.apiAnswer({result:"password changed"},error,response);
		});
	});
 
module.exports = router;