var path                = require("path"),
    express             = require("express"),
    bodyParser          = require('body-parser'),
    cors                = require('cors'),
    config              = require("app/core/config")(),
    helper              = require("app/core/helper"),
	apiRoutes           = require('app/routes/api'),
	webRoutes           = require('app/routes/web');

module.exports = function(callback) {
    var app = express();

    // Configure the app
    app.set("view engine", "ejs");
    app.set("views", path.join(__dirname, "views"));
    app.set("trust proxy", true);

    // Setup static routes to public assets
    app.use(cors(helper.cors_delegate));
    app.use(express.static(path.join(__dirname, "public")));
    app.use(bodyParser.json());

    // Setup HTTP routes for rendering views
	app.use('/', webRoutes);

    // Setup HTTP routes for various APIs we wish to implement
    // the responses to these are typically JSON
	app.use('/api', apiRoutes);

    // Listen on our server
    app.listen(config.server.port, callback);
}