#! /bin/bash
##
# Simple bash script to automate installation of the Piraten.LiveBox in kiosk mode
#
# Dependencies:
# 1: Bash
##
export DEBIAN_FRONTEND=noninteractive
export DEBIAN_PRIORITY=critical
clear

# Set up colors
yellow=`tput setaf 3`;
green=`tput setaf 2`;
clear=`tput sgr0`;
scriptdir=$(cd "$(dirname "$(readlink -f "$0")")" >/dev/null 2>&1 && pwd)


# Start it up ...
echo "${green}"
echo "============================================"
echo ""
echo "Begin install"
echo ""
echo "============================================"
echo "${clear}"

# add a simple yes/no confirmation before we proceed
echo "${yellow}Run Install? (y/n)${clear}"
read -e run
echo ""

# if the user didn't say no, then go ahead an install
if [ "$run" == n ] ; then
    exit
fi


clear
echo "${green}"
echo "============================================"
echo "Installing required packages"
echo "============================================"
echo "${clear}"

echo "${green} - Installing git${clear}"
sudo apt -y install --no-install-recommends git

echo "${green} - Installing node.js and npm${clear}"
curl -sL https://deb.nodesource.com/setup_14.x | sudo bash -
sudo apt -y install --no-install-recommends nodejs

echo "${green} - Provision${clear}"
npm run provision


echo "${green}"
echo "============================================"
echo "Installing Piraten.Box"
echo "============================================"
echo "${clear}"
cd $scriptdir

echo "${green} - Install${clear}"
npm install

echo "${green} - Start${clear}"
npm start


#clear
echo "${green}"
echo "================================================================="
echo ""
echo "Installation is complete. :)"
echo "The system will now reboot to complete setup!"
echo ""
echo "Connect to WiFi 'PiratenBox' with passcode 'PiratenBoxInstaller' and"
echo "access 'http://192.168.42.1:4242/setup' to configure your device."
echo ""
echo "================================================================="
echo "${clear}"