require('app-module-path/register');

var chromeLauncher      = require('chrome-launcher'),
    wmctrl              = require('window-control'),
    exec                = require("child_process").exec,
    screen              = require("app/core/screen")(),
    config              = require("app/core/config")();


var getWindowList = (callback) => {
	exec(`wmctrl -lp`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
		if (error) return callback(error);
        if (stderr) return callback(stderr);
        windowStrings = stdout.split('\n');
        windowList = [];
        windowStrings.forEach((windowString) => {
			let windowId = windowString.split(' ')[0];
			let windowPid = windowString.split(' ')[3];
			let windowTitle = windowString.split(' ').slice(4).join(' ').trim();
			windowObject = {id: windowId, pid: windowPid, title: windowTitle};
			if (windowId&&windowPid) windowList.push(windowObject);
        })
		callback(null, windowList);
	});
};

var getWindowByPid = (pid, callback) => {
	if (!pid) return;
	getWindowList(function(error, windowList){
		if (error) return callback(error);
        windowList.forEach((windowObject) => {
			if (windowObject.pid==pid) {
				return callback(null, windowObject);
			};
        })
		return callback('not found');
	});
};

var focusWindow = (id, callback) => {
	exec(`wmctrl -i -a ${id}`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
		if (error) return callback(error);
        if (stderr) return callback(stderr);
		callback();
	});
};

var watchChrome = (pid, refocus, restartCallback) => {
	setInterval(function(){
		getWindowByPid(pid, (error, windowObject) => {
			if (error=='not found') {
				console.log("restart", pid);
//				restartCallback();
			} else if (!error && refocus) {
				console.log("refocus", windowObject);
				focusWindow(windowObject.id, (error) => {
					if (error) console.log('ERROR', error);
				});
			}
		})
	}, 2000);
};

var startChrome = (options, refocus) => {
	chromeLauncher.launch(options).then(chrome => {
		console.log(`Chrome debugging port running on ${chrome.port}`);
		setTimeout(function(){
			watchChrome(chrome.pid, refocus, function(){
				startChrome(options, refocus);
			});
		}, 2000);
	});
};

config.kiosk.instances.forEach((instance) => {
	screen.get_monitor(instance.monitor, function(error, monitor) {
		var newFlags = chromeLauncher.Launcher.defaultFlags().filter(flag => flag !== '--mute-audio');
		if (instance.mode == 'fullscreen') {
			newFlags.push('--kiosk');
			newFlags.push('--window-position=' + monitor.position.x + ',' + monitor.position.y);
			newFlags.push('--window-size=' + monitor.width + ',' + monitor.height);
			startChrome({
				startingUrl: instance.url,
				port: instance.port,
				ignoreDefaultFlags: true,
				chromeFlags: newFlags,
				envVars: {'DISPLAY': ':0.0'}
			}, false);
		}
		if (instance.mode == 'window') {
			newFlags.push('--app='+instance.url);
			newFlags.push('--window-position=' + monitor.position.x + instance.position.x + ',' + monitor.position.y + instance.position.y);
			newFlags.push('--window-size=' + instance.size.x + ',' + instance.size.y);
			startChrome({
				port: instance.port,
				ignoreDefaultFlags: true,
				chromeFlags: newFlags,
				envVars: {'DISPLAY': ':0.0'}
			}, true);
		}
	});
});
