# PiratenBox

A Node.js application to setup and control Raspberry Pi's especially for events.

Tested with Raspberry Pi OS Buster Light and Desktop on Raspberry Pi 3 and 4.

It may work on bullseye if you name your user `pi`, but is currently untestet.

It may work on other debian distros if you have `raspi-config` installed and your display manager is `LXDE`, but is currently untestet.

## Why?

When you need to deploy a new device, especially headless devices, you normaly need to setup much things with the command line.

That's not really comfortable and requires some time to get all the things ready.

This project makes it easy to get new devices configured and the required software ready to use.

## What is it?

A tool to confige your device headless throught a web gui

It comes with an integrated hotspot, that automatically starts if the device has no network connection.

You can extend it by installing modules, some integrated, some integrate external software

## Modules

* Akk-Tool
  * https://piraten.tools/akk/
  * https://github.com/DJaeger/akk
* Companion
  * https://bitfocus.io/companion
  * https://github.com/bitfocus/companion
* Companion Satellite
  * https://github.com/bitfocus/companion-satellite
* OpenSlides
  * https://openslides.com/
  * https://github.com/OpenSlides/OpenSlides
* Kiosk
  * Integrated
* ScreenStream
  * Integrated

## Features

* Info
  * System
  * OS
  * CPU
  * Memory
  * USB
  * Disks
  * BlockDevices
  * Filesystems
  * UUID
  * Users
* PiratenBox
  * Autostart
  * Restart / Stop
  * Change Port
* Operating System
  * Shutdown / Reboot
  * Update system packages
  * Change Language  (keyboard & display)
  * Change Hostname
  * Change Password (pi user)
* Audio
  * Default device
  * Mixer
* Network
  * Control service & interface
  * Active connections
  * Dis-/Connect WiFi
  * Forget WiFis
* Hotspot
  * Control service
  * Change SSID & password
* Bluetooth
  * Control service & Interface
  * Active Connections
  * Paired Devices
  * Pairing & Connecting
* Display
  * Screen Settings
  * Touchscreen (modules)
    * LCD-show
    * rpi_touch_driver
* System
  * Shutdown / Reboot
  * Update system packages
  * Settings

## Requirements

Libraries used by the frontend are defined in bower.json.

Node.js modules and external dependencies are defined in the package.json file.

All requirements will be installed automatically if you install like described below.

## Install

```sh
git clone https://github.com/Piraten-Tools/PiratenBox.git
cd PiratenBox
bash install.sh
npm start
```

### Gotchas

#### `hostapd`

The `hostapd` application does not like to behave itself on some wifi adapters (RTL8192CU et al). This link does a good job explaining the issue and the remedy: [Edimax Wifi Issues](http://willhaley.com/blog/raspberry-pi-hotspot-ew7811un-rtl8188cus/). The gist of what you need to do is as follows:

```sh
# run iw to detect if you have a rtl871xdrv or nl80211 driver
iw list
```

If the above says `nl80211 not found.` it means you are running the `rtl871xdrv` driver and probably need to update the `hostapd` binary as follows:
```sh
cd PiratenBox
sudo mv /usr/sbin/hostapd /usr/sbin/hostapd.OLD
sudo mv assets/bin/hostapd.rtl871xdrv /usr/sbin/hostapd
sudo chmod 755 /usr/sbin/hostapd
```

Note that the `wifi_driver_type` config variable is defaulted to the `nl80211` driver. However, if `iw list` fails on the app startup, it will automatically set the driver type of `rtl871xdrv`. Remember that even though you do not need to update the config / default value - you will need to use the updated `hostapd` binary bundled with this app.

## Usage


## User Interface

In AP mode the IP is configured to `192.168.42.1` and the AP SSID to `PiratenBox` with default pass `PiratenBoxInstaller`.

Step 1: Power on Pi which runs this app on startup (assume it is not configured for a wifi connection). Once it boots up, you will see `PiratenBox` among the wifi connections.  The password is configured in `config.json`.

Step 2: Join the above network, and navigate to the static IP and port we set in config.json (`http://192.168.42.1:4242`), you will see the setup assistant at first start.

Step 3: Select your your required modules, wifi settings if needded, and let the PiratenBox do the rest. You are done! Your Pi is now on your events wifi!

## Credits

The wifi feature is based on:
https://github.com/sabhiram/raspberry-wifi-conf
This project broadly follows these [instructions](https://www.raspberrypi.org/documentation/configuration/wireless/access-point.md) in setting up a RaspberryPi as a wireless AP.

Some configurations are inspired by or use
https://github.com/RPi-Distro/raspi-config

Required packages can be found in package.json and bower.json