const { pamAuthenticate, pamErrors } = require("node-linux-pam");

module.exports = function basicAuth(req, res, callback) {
    // make authenticate path public
    if (req.path === '/' || req.path === '/Setup' || req.path === '/KioskLaunch' || req.path === '/authenticate') {
        return callback();
    }

    // check for basic auth header
    if (!req.headers.authorization || req.headers.authorization.indexOf('Basic ') === -1) {
        return res.status(401).json({ message: 'Missing Authorization Header' });
    }

    // verify auth credentials
    const base64Credentials =  req.headers.authorization.split(' ')[1];
    const credentials = Buffer.from(base64Credentials, 'base64').toString('ascii');
    const [username, password] = credentials.split(':');
    const pam_credentials = {
        username: username,
        password: password,
    };
    pamAuthenticate(pam_credentials, (err, code) => {
        if (!err) {
            console.log('Authenticated!');
            return;
        }

        if (code === pamErrors.PAM_NEW_AUTHTOK_REQD) {
            console.log('Authentication token is expired');
            return res.status(401).json({ message: 'Authentication token is expired' });
        }

        // attach user to request object
        req.username = username

        console.log(err, code);
        callback(err);
    });

}
