var config              = require("config/config.json"),
    fs                  = require("fs-extra"),
    path                = require("path");

/*****************************************************************************\
    Return the config and a function which we can use to change config file
\*****************************************************************************/
module.exports = function() {

    config.root = path.join(__dirname, '..', '..');

    config.load = function(callback) {
        fs.readJson(config.root + '/config/config.json', {throws:false}, function(error,data) {
            if (!error) {
                data.root = config.root;
                data.load = config.load;
                data.save = config.save;
                config = data;
            }
            callback(error,config);
        })
    };

    config.save = function(config, callback) {
        console.log('config - Saving to ' + config.root + '/config/config.json', config);
        fs.writeJson(config.root + '/config/config.json', config, {spaces:4}, function(error) {
            if (!error) console.log('config - Saved successfully');
            callback(error, config);
        })
    };

    return config;
}
