var _               = require("underscore")._,
    async           = require("async"),
    fs              = require("fs-extra");

exports = module.exports = {};

exports.apiAnswer     = apiAnswer;
exports.corsDelegate  = corsDelegate;
exports.writeTemplate = writeTemplate;

// Helper function to log errors and send a generic status "SUCCESS"
// message to the caller
function apiAnswer (success_obj, error, response) {
    if (error) {
        console.log("API - ERROR: " + error);
        response.send({ status: "ERROR", error: error });
    } else {
        success_obj = success_obj || {};
        success_obj["status"] = "SUCCESS";
        response.send(success_obj);
    }
    response.end();
};

function corsDelegate (req, callback) {
	let origin_str = `${req.header("Origin")}`;
	wifi.get_wifi_info((err,result) => {
		if (err) {
			callback(err,{origin:false});
		} else if (origin_str.includes(result.inet_addr)) {
			callback(null,{origin:true});
		} else {
			callback(null,{orign:false});
		}
	});
};

/*****************************************************************************\
    Return a helper function to write a given template to a file based on a
    given context
\*****************************************************************************/
// Better template format
_.templateSettings = {
	interpolate: /\{\{(.+?)\}\}/g,
	evaluate :   /\{\[([\s\S]+?)\]\}/g
};

function writeTemplate(template_path, file_name, context, callback) {

	async.waterfall([

		function read_template_file(next_step) {
			fs.readFile(template_path, {encoding: "utf8"}, next_step);
		},

		function write_file(file_txt, next_step) {
			var template = _.template(file_txt);
			var templateContent = template(context);
			fs.writeFile(template_path + '.temp', templateContent, next_step);
		},

		function update_file(next_step) {
			exec("sudo mv -f " + template_path + ".temp " + file_name, next_step);
		}

	], callback);

}