var config              = require("app/core/config")(),
    wifi                = require("app/core/wifi")();

/*****************************************************************************\
    Return the config and a function which we can use to change config file
\*****************************************************************************/
module.exports = function() {

    var _enable = function(callback) {
        console.log('hotspot - Enable autostart...');
        config.load(function(error,config) {
            if (error) return callback(error);
            config.access_point.autoenable = true;
            config.save(config, function(error) {
                if (!error) console.log('hotspot - Changed config successfully');
                callback(error);
            });
        })
    };

    var _disable = function(callback) {
        console.log('hotspot - Disable autostart...');
        config.load(function(error,config) {
            if (error) return callback(error);
            config.access_point.autoenable = false;
            config.save(config, function(error) {
                if (!error) console.log('hotspot - Changed config successfully');
                callback(error);
            });
        })
    };

    var _start = function(callback) {
        console.log('hotspot - Start...');
        wifi.enable_ap_mode(config.access_point.ssid, function(error) {
            if(error) {
                console.log("hotspot - Start ERROR: " + error);
                callback(error)
            } else {
                callback();
                console.log("hotspot - Started successfully...!");
            }
        });
    };

    var _stop = function(callback) {
        console.log('hotspot - Stop...');
        wifi.enable_wifi_mode({}, function(error) {
            if (!error) console.log("hotspot - Stopped successfully...");
            callback(error);
        })
    };

    var _is_enabled = function(callback) {
        config.load(function(error,config) {
            if (error) return callback(error);
            var enabled = config.access_point.autoenable || false;
            callback(null, enabled);
        })
    };

    var _is_active = function(callback) {
        wifi.is_ap_enabled(function(error, ap_ssid) {
            if (error) {
                callback(error);
            } else if (ap_ssid) {
                callback(null, true);
            } else {
                callback(null, false);
            }
        })
    };

    var _change_ssid = function(ssid, callback) {
        console.log('hotspot - Change SSID to "' + ssid + '"...');
        config.load(function(error,config) {
            if (error) return callback(error);
            if (!config.access_point) config.access_point = {};
            config.access_point.ssid = ssid;
            config.save(config, function(error) {
                if (!error) console.log('hotspot - Changed config successfully');
                _is_active(function(error, active) {
                    if (error) return callback(error);
                    if (active) {
                        console.log('hotspot - Is active - Restarting');
                        _restart(function(error) {
                            if (!error) console.log('hotspot - Restarted successfully');
                            callback(error);
                        });
                    }
                });
            });
        });
    };

    var _get_ssid = function(callback) {
        console.log('hotspot - Get current SSID from config...');
        if (config.access_point&&config.access_point.ssid) callback(null, config.access_point.ssid)
        else callback('hotspot - No ssid set');
    };

    var _change_passphrase = function(passphrase, callback) {
        console.log('hotspot - Change passphrase to "' + passphrase + '"...');
        config.load(function(error,config) {
            if (error) return callback(error);
            if (!config.access_point) config.access_point = {};
            config.access_point.passphrase = passphrase;
            config.save(config, function(error) {
                if (!error) console.log('hotspot - Changed config successfully');
                _is_active(function(error, active) {
                    if (error) return callback(error);
                    if (active) {
                        console.log('hotspot - Is active - Restarting');
                        _restart(function(error) {
                            if (!error) console.log('hotspot - Restarted successfully');
                            callback(error);
                        });
                    }
                });
            });
        });
    };

    var _get_passphrase = function(callback) {
        console.log('hotspot - Get current passphrase from config...');
        if (config.access_point&&config.access_point.passphrase) callback(null, config.access_point.passphrase)
        else callback('hotspot - No passphrase set');
    };

    return {
        enable:                     _enable,
        disable:                    _disable,
        start:                      _start,
        stop:                       _stop,
        is_enabled:                 _is_enabled,
        is_active:                  _is_active,
        change_ssid:                _change_ssid,
        get_ssid:                   _get_ssid,
        change_passphrase:          _change_passphrase,
        get_passphrase:             _get_passphrase,
    };
}
