var fs                  = require("fs-extra"),
    config              = require("app/core/config")();

/*****************************************************************************\
    Return the config and a function which we can use to change config file
\*****************************************************************************/
module.exports = function() {

    var _get_available = function(callback) {
		var modules_available = {};
		var modules = fs.readdirSync(config.root + '/app/modules');
		modules.forEach(function (module, index) {
			var moduleInfoFile = config.root + '/app/modules/' + module + '/package.json';
			if (fs.existsSync(moduleInfoFile)) {
				var packageJson = fs.readJsonSync(moduleInfoFile, {throws:false});	
				if (packageJson && packageJson.moduleName) {
					modules_available[module] = {
						'name': packageJson.moduleName,
						'description': packageJson.description,
						'status': false
					};
				}
			}
		});
		callback(null, modules_available);
    };

    var _get_installed = function(callback) {
        config.load(function(error,config) {
            if (error) return callback(error);
            if (!config.modules) config.modules = {};
            var installed = [];
            Object.keys(config.modules).filter((o)=>{if(config.modules[o])installed.push(o)});
            console.log("modules - installed: ",installed);
            callback(null,installed);
        })
    };


    return {
        get_available:              _get_available,
        get_installed:              _get_installed,
    };
}
