var async           = require("async"),
    fs              = require("fs-extra"),
    systemctl       = require("systemctl-cmd"),
    config          = require("app/core/config")();

/*****************************************************************************\
    Return a set of functions which we can use to install and
    control the main server
\*****************************************************************************/
module.exports = function() {

    var _install = function(callback) {
        async.waterfall([
            function create_service(next_step) {
                console.log('piratenbox - Create service...');
				exec(`sudo cp -f ` + config.root + `/assets/systemd/PiratenBox.service /etc/systemd/system/PiratenBox.service`, function(error) {
					if (!error) console.log('piratenbox - Service created successfully');
					next_step(error);
				});
            },
            function reload_services(next_step) {
                console.log('piratenbox - Reload services...');
                systemctl.daemonReload(true).then(function(result) {
                    if (!result.error) console.log('piratenbox - Services reloaded successfully');
                    next_step(result.error);
                });
            }
        ], callback);
    };

    var _enable = function(callback) {
        console.log('piratenbox - Enable service...');
        systemctl.enable('PiratenBox',true).then(result => {
            if (!result.error) console.log('piratenbox - Service enabled successfully');
            callback(result.error);
        })
    };

    var _disable = function(callback) {
        console.log('piratenbox - Disable service...');
        systemctl.disable('PiratenBox',true).then(result => {
            if (!result.error) console.log('piratenbox - Service disabled successfully');
            callback(result.error);
        })
    };

    var _stop = function(callback) {
        console.log('piratenbox - Stop service...');
        systemctl.stop('PiratenBox',true).then(result => {
            if (!result.error) console.log('piratenbox - Service stopped successfully');
            callback(result.error);
        })
    };

    var _restart = function(callback) {
        console.log('piratenbox - Restarting service...');
        systemctl.restart('PiratenBox',true).then(result => {
            if (result.error) callback(result.error)
            else {
                console.log('piratenbox - Service restarted successfully');
                callback();
            }
        })
    };

    var _change_port = function(port, callback) {
        console.log('piratenbox - Changing PiratenBox port...');
        async.waterfall([
            function save_config(next_step) {
                console.log('piratenbox - Saving config...');
				config.server.port = port;
                config.save(config, function(error) {
                    if (!error) console.log('piratenbox - Saved config successfully');
                    next_step(error);
                });
            },
            function restart_service(next_step) {
				console.log('piratenbox - Restarting service...');
				_restart(function(error) {
					if (!error) console.log('piratenbox - Service restarted successfully');
					next_step(error);
				});
            }
        ], callback);
    };

    var _get_port = function(callback) {
		if (config.server && config.server.port)
			callback(null, config.server.port);
		else callback('Port not set in config');
    };

    var _is_installed = function(callback) {
        fs.pathExists('/etc/systemd/system/PiratenBox.service', callback);
    };

    var _is_enabled = function(callback) {
        systemctl.isEnabled('PiratenBox').then(enabled => {
            callback(null, enabled);
//            console.log('piratenbox - ' + (enabled ? 'Enabled' : 'Not enabled'));
        }, error => {
            callback(error);
        })
    };

    var _is_active = function(callback) {
        systemctl.isActive('PiratenBox').then(active => {
            callback(null, active);
//            console.log('piratenbox - ' + (active ? 'Active' : 'Not active'));
        }, error => {
            callback(error);
        })
    };

    return {
        install:                    _install,
        enable:                     _enable,
        disable:                    _disable,
        stop:                       _stop,
        restart:                    _restart,
        get_port:                   _get_port,
        change_port:                _change_port,
        is_installed:               _is_installed,
        is_enabled:                 _is_enabled,
        is_active:                  _is_active,
    };
}
