var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    akk               = require("app/modules/akk")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/akk/views/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/services/akk.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/akk/services/akk.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/controller/akk.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/akk/controller/akk.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		akk.install(request.body,function(error) {
			console.log("Installed Akk-Tool: " + (!error));
			helper.apiAnswer({result:"Akk-Tool installed"},error,response);
		});
	});

router.route("/get_port")
	.get(function(request, response) {
		akk.get_port(function(error,result) {
			console.log("Got Akk-Tool port: " + result);
			helper.apiAnswer({port:result},error,response);
		});
	});

router.route("/change_port")
	.post(function(request, response) {
		akk.change_port(request.body,function(error) {
			console.log("Changed Akk-Tool port: " + (!error));
			helper.apiAnswer({result:"Akk-Tool port changed"},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		akk.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

module.exports = router;
