var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    companion_satellite = require("app/modules/companion_satellite")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/companion_satellite/views/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/services/companion_satellite.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/companion_satellite/services/companion_satellite.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/controller/companion_satellite.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/companion_satellite/controller/companion_satellite.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		companion_satellite.install(request.body,function(error) {
			console.log("Installed Companion Satellite: " + (!error));
			helper.apiAnswer({result:"Companion Satellite installed"},error,response);
		});
	});

router.route("/start")
	.get(function(request, response) {
		companion_satellite.start(function(error) {
			console.log("Started Companion Satellite: " + (!error));
			helper.apiAnswer({result:"Companion Satellite started"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		companion_satellite.stop(function(error) {
			console.log("Stopped Companion Satellite: " + (!error));
			helper.apiAnswer({result:"Companion Satellite stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		companion_satellite.restart(function(error) {
			console.log("Restarted Companion Satellite: " + (!error));
			helper.apiAnswer({result:"Companion Satellite restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		companion_satellite.enable(function(error) {
			console.log("Enabled Companion Satellite: " + (!error));
			helper.apiAnswer({result:"Companion Satellite enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		companion_satellite.disable(function(error) {
			console.log("Disabled Companion Satellite: " + (!error));
			helper.apiAnswer({result:"Companion Satellite disabled"},error,response);
		});
	});

router.route("/ip_address")
	.get(function(request, response) {
		companion_satellite.get_ip_address(function(error,result) {
			console.log("Got Companion Satellite IP Address: " + result);
			helper.apiAnswer({ip_address:result},error,response);
		});
	})
	.put(function(request, response) {
		companion_satellite.change_ip_address(request.body.ip_address,function(error) {
			console.log("Changed Companion Satellite IP Address: " + (!error));
			helper.apiAnswer({result:(!error)},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		companion_satellite.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		companion_satellite.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		companion_satellite.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});
 
module.exports = router;
