"use strict";

angular.module("companion_satellite", [])
    .service("companion_satellite", ["$http", "$location",

    function($http, $location) {
        return {

            is_installed: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/is_installed");
            },
            install: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/install");
            },
            start: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/start");
            },
            stop: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/stop");
            },
            restart: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/restart");
            },
            enable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/enable");
            },
            disable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/disable");
            },
            set_ip_address: function(ip_address, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.put("http://" + hostname + ":4242/api/companion_satellite/ip_address", ip_address);
            },
            get_ip_address: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/ip_address");
            },
            is_active: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/is_active");
            },
            is_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/companion_satellite/is_enabled");
            },

        };
    }]

);
