var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    dicaffeine        = require("app/modules/dicaffeine")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/dicaffeine/views/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/services/dicaffeine.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/dicaffeine/services/dicaffeine.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/controller/dicaffeine.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/dicaffeine/controller/dicaffeine.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		dicaffeine.install(request.body,function(error) {
			console.log("Installed Dicaffeine: " + (!error));
			helper.apiAnswer({result:"Dicaffeine installed"},error,response);
		});
	});

router.route("/start")
	.get(function(request, response) {
		dicaffeine.start(function(error) {
			console.log("Started Dicaffeine: " + (!error));
			helper.apiAnswer({result:"Dicaffeine started"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		dicaffeine.stop(function(error) {
			console.log("Stopped Dicaffeine: " + (!error));
			helper.apiAnswer({result:"Dicaffeine stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		dicaffeine.restart(function(error) {
			console.log("Restarted Dicaffeine: " + (!error));
			helper.apiAnswer({result:"Dicaffeine restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		dicaffeine.enable(function(error) {
			console.log("Enabled Dicaffeine: " + (!error));
			helper.apiAnswer({result:"Dicaffeine enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		dicaffeine.disable(function(error) {
			console.log("Disabled Dicaffeine: " + (!error));
			helper.apiAnswer({result:"Dicaffeine disabled"},error,response);
		});
	});

router.route("/port")
	.get(function(request, response) {
		dicaffeine.get_port(function(error,result) {
			console.log("Got Dicaffeine port: " + result);
			helper.apiAnswer({port:result},error,response);
		});
	})
	.put(function(request, response) {
		dicaffeine.change_port(request.body.port,function(error) {
			console.log("Changed Dicaffeine port: " + (!error));
			helper.apiAnswer({result:(!error)},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		dicaffeine.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		dicaffeine.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		dicaffeine.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});
 
module.exports = router;
