angular.module("dicaffeine", [])
	.controller("dicaffeine", ["dicaffeine", "$scope", "$location", "$interval",

    function(dicaffeine, $scope, $location, $interval) {

        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;
        $scope.port                   = 8080;

        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            dicaffeine.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Dicaffeine installiert: " + response.data.result);
					if (response.data.result) {
						$scope.status = "installed";
					} else {
						$scope.status = false;
					}
                } else {
                    $scope.status = false;
                }
            });
        }

        $scope.install = function() {
            $scope.status = "installing";
            dicaffeine.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Dicaffeine installiert: "+response.data.result);
                    $scope.status = "installed";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.start = function() {
            $scope.status = "starting";
            dicaffeine.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Dicaffeine gestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.stop = function() {
            $scope.status = "stopping";
            dicaffeine.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Dicaffeine gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.restart = function() {
            $scope.status = "restarting";
            dicaffeine.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Dicaffeine neugestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "restarted";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            dicaffeine.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Dicaffeine aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            dicaffeine.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Dicaffeine deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.set_port = function() {
            dicaffeine.set_port({port:$scope.port}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Dicaffeine Port geändert: " + response.data.result);
                }
            });
        }

        $scope.get_port = function() {
            dicaffeine.get_port().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.port = response.data.port;
                }
            });
        }

        $scope.is_enabled = function() {
            dicaffeine.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            dicaffeine.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.is_installed();
        $scope.is_enabled();
        $scope.is_active();
        $scope.get_port();
        $interval(function() {
            $scope.is_installed();
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);