"use strict";

angular.module("dicaffeine", [])
    .service("dicaffeine", ["$http", "$location",

    function($http, $location) {
        return {

            is_installed: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/is_installed");
            },
            install: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/install");
            },
            start: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/start");
            },
            stop: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/stop");
            },
            restart: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/restart");
            },
            enable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/enable");
            },
            disable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/disable");
            },
            set_port: function(port, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.put("http://" + hostname + ":4242/api/dicaffeine/port", port);
            },
            get_port: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/port");
            },
            is_active: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/is_active");
            },
            is_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/dicaffeine/is_enabled");
            },

        };
    }]

);
