var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    kiosk             = require("app/modules/kiosk")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/kiosk/views/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/services/kiosk.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/kiosk/services/kiosk.js', 'utf8', function (error, data) {
		    if (error) response.send(error);
			else response.send(data);
		});
	});
router.route("/services/kiosklaunch.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/kiosk/services/kiosklaunch.js', 'utf8', function (error, data) {
		    if (error) response.send(error);
			else response.send(data);
		});
	});

router.route("/controller/kiosk.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/kiosk/controller/kiosk.js', 'utf8', function (error, data) {
		    if (error) response.send(error);
			else response.send(data);
		});
	});
router.route("/controller/kiosklaunch.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/kiosk/controller/kiosklaunch.js', 'utf8', function (error, data) {
		    if (error) response.send(error);
			else response.send(data);
		});
	});

router.route("/install")
	.post(function(request, response) {
		kiosk.install(function(error) {
			console.log("Installed Kiosk: " + (!error));
			helper.apiAnswer({result:"Kiosk installed"},error,response);
		});
	});

router.route("/start")
	.get(function(request, response) {
		kiosk.start(function(error) {
			console.log("Started Kiosk: " + (!error));
			helper.apiAnswer({result:"Kiosk started"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		kiosk.stop(function(error) {
			console.log("Stopped Kiosk: " + (!error));
			helper.apiAnswer({result:"Kiosk stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		kiosk.restart(function(error) {
			console.log("Restarted Kiosk: " + (!error));
			helper.apiAnswer({result:"Kiosk restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		kiosk.enable(function(error) {
			console.log("Enabled Kiosk: " + (!error));
			helper.apiAnswer({result:"Kiosk enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		kiosk.disable(function(error) {
			console.log("Disabled Kiosk: " + (!error));
			helper.apiAnswer({result:"Kiosk disabled"},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		kiosk.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		kiosk.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		kiosk.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/change_url")
	.post(function(request, response) {
		kiosk.change_url(request.body.url,function(error) {
			console.log("Changed Kiosk URL: " + (!error));
			helper.apiAnswer({result:"Changed URL"},error,response);
		});
	});

router.route("/instances")
	.get(function(request, response) {
		kiosk.get_instances(function(error,result) {
			if ( !error && result ) {
				console.log("Got Kiosk instances: " + result);
			}
			helper.apiAnswer({instances:result},error,response);
		});
	})
	.post(function(request, response) {
		kiosk.save_instances(request.body,function(error) {
			console.log("Saved Kiosk instances: " + (!error));
			helper.apiAnswer({result:"Saved Kiosk instances"},error,response);
		});
	});


router.route("/defaulturl")
	.get(function(request, response) {
		kiosk.get_defaulturl(function(error,result) {
			if ( !error && result ) {
				console.log("Got Kiosk default URL: " + result);
			}
			helper.apiAnswer({defaulturl:result},error,response);
		});
	})
	.post(function(request, response) {
		kiosk.set_defaulturl(request.body.defaulturl,function(error) {
			console.log("Saved Kiosk default url: " + (!error));
			helper.apiAnswer({result:"Saved Kiosk default url"},error,response);
		});
	});

module.exports = router;
