angular.module("kiosk", [])
	.controller("kiosk", ["kiosk", "screen", "$scope", "$location", "$interval",

    function(kiosk, screen, $scope, $location, $interval) {

        $scope.monitors               = {};
        $scope.monitor_count          = 0;
        $scope.instances              = {};
        $scope.defaulturl             = "http://localhost:4242/";
        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;
        $scope.changed                = false;

        $scope.install = function() {
            $scope.status = "installing";
            kiosk.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk installiert: "+response.data.result);
                    $scope.status = "installed";
                } else {
                    $scope.status = "failed";
                }
            });
        }
        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            kiosk.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk installiert: " + response.data.result);
					if (response.data.result) {
						$scope.status = "installed";
					} else {
						$scope.status = false;
					}
                } else {
                    $scope.status = false;
                }
            });
        }

        $scope.start = function() {
            $scope.status = "starting";
            kiosk.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk gestartet: " + response.data.result);
					$scope.get_instances();
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }
        $scope.stop = function() {
            $scope.status = "stopping";
            kiosk.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }
        $scope.restart = function() {
            $scope.status = "restarting";
            kiosk.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk neugestartet: " + response.data.result);
					$scope.get_instances();
                    $scope.active = true;
                    $scope.status = "restarted";
                } else {
                    $scope.status = "failed";
                }
            });
        }
        $scope.is_active = function() {
            kiosk.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            kiosk.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }
        $scope.disable = function() {
            $scope.status = "disabling";
            kiosk.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }
        $scope.is_enabled = function() {
            kiosk.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.get_instances = function() {
            kiosk.get_instances().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.instances = response.data.instances;
                }
            });
        }
        $scope.add_instance = function() {
			$scope.instances.push({
				"name": "Neue Kiosk-Instanz",
				"monitor": Object.keys($scope.monitors)[0],
				"mode": "fullscreen",
				"url":$scope.defaulturl,
				"changed":true,
                "position": {
                    "x": 0,
                    "y": 0
                },
                "size": {
                    "x": 0,
                    "y": 0
                }
			});
        }
        $scope.delete_instance = function(index) {
			$scope.instances.splice( index, 1 );
			$scope.save_instances();
        }
        $scope.save_instances = function() {
            kiosk.save_instances($scope.instances).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.get_instances();
                }
            });
        }

        $scope.get_defaulturl = function() {
            kiosk.get_defaulturl().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.defaulturl = response.data.defaulturl;
                }
            });
        }
        $scope.set_defaulturl = function() {
            kiosk.set_defaulturl({defaulturl:$scope.defaulturl}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk Standard URL geändert: " + response.data.result);
                }
            });
        }

        $scope.get_monitors = function() {
            screen.get_monitors().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.monitors = response.data.monitors;
					console.log("Monitors: ", $scope.monitors);
					$scope.monitor_count = Object.keys(response.data.monitors).length;
                }
            });
        }

        $scope.check_name = function(name) {
			return $scope.instances.filter(e=>e.name===name).length==1;
        }


        $scope.is_installed();
        $scope.is_enabled();
        $scope.is_active();
        $scope.get_monitors();
        $scope.get_instances();
        $scope.get_defaulturl();
        $interval(function() {
            $scope.is_installed();
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);
