angular.module("lcdshow", [])
	.controller("lcdshow", ["lcdshow", "$scope", "$interval",

    function(lcdshow, $scope, $interval) {

        $scope.status                 = false;
        $scope.installed              = false;
        $scope.enabled                = false;
        $scope.modes                  = {};
        $scope.selected_mode          = '';

        $scope.install = function() {
            $scope.status = "installing";
            lcdshow.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("LCD-show installiert: "+response.data.result);
					$scope.installed = response.data.result;
					if (response.data.result) {
						$scope.status = "installed";
					} else {
						$scope.status = false;
					}
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
			if($scope.selected_mode=='')return;
            $scope.status = "enabling";
            lcdshow.enable({mode:$scope.selected_mode}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("LCD-show aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            lcdshow.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("LCD-show deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            lcdshow.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.installed = response.data.result;
                    if (response.data.result) $scope.status = "installed";
                }
            });
        }

        $scope.is_enabled = function() {
            lcdshow.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }


        $scope.get_modes = function() {
            lcdshow.get_modes().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.modes = response.data.modes;
                    return response.data.modes;
                } else {
                    return {};
                }
            });
        }
		
		$scope.is_installed();
		$scope.is_enabled();
		$scope.get_modes();
        $interval(function() {
            $scope.is_enabled();
        }, 5000);

    }]
);