var async           = require("async"),
    fs              = require("fs-extra"),
    exec            = require("child_process").exec,
    systemctl       = require("systemctl-cmd"),
    apt             = require("apt"),
    config          = require("app/core/config")();

/*****************************************************************************\
    Return a set of functions which we can use to install and
    control components
\*****************************************************************************/
module.exports = function() {

    var _install = function(callback) {
        console.log("= Installing LCD-show =");

        async.waterfall([
            function install_dependencies(next_step) {
                console.log('Installing dependencies...');
                apt.install('git', function(error) {
                    if (!error) console.log("Dependencies installed successfully...");
                    next_step(error);
                });
            },
            function reload_config(next_step) {
                console.log("Reloading config...");
                config.load(function(error, data) {
                    if (!error) {
                        config = data;
                        console.log("Reloaded config successfully");
                    }
                    next_step(error);
                });
            },
            function add_yarn_to_path(next_step) {
                console.log("Removing existing data...");
                exec(`sudo rm -rf /home/pi/LCD-show/`, function(error, stdout, stderr) {
                    if (!error) console.log("Removed existing data successfully");
                    next_step(error);
                });
            },
            function cloning_git_repo(next_step) {
                console.log("Cloning git repo...");
                exec(`cd /home/pi && rm -rf LCD-show && git clone --depth 1 https://github.com/goodtft/LCD-show.git`, function(error, stdout, stderr) {
                    if (!error) console.log("Cloned git repo successfully");
                    next_step(error);
                });
            },
            function fix_permissions(next_step) {
                console.log("Fixing permissions...");
                exec(`chmod -R 755 /home/pi/LCD-show`, function(error, stdout, stderr) {
                    if (!error) console.log("Fixed permissions successfully");
                    next_step(error);
                })
            },
            function save_config(next_step) {
                console.log(`Saving config...`);
                if (!config.modules) config.modules = {};
                config.modules.lcdshow = true;
                if (!config.lcdshow) config.lcdshow = {};
                config.lcdshow.installed = true;
                config.save(config, function(error) {
                    if (!error) console.log(`Saved config successfully`);
                    next_step(error);
                });
            }
        ], callback);
    };

    var _enable = function(mode,callback) {
        var command = mode + '-show';
        if (mode == 'LCD-hdmi') command = mode;
        fs.pathExists(`/home/pi/LCD-show/${command}`, function(error, exists) {
            if (!exists) return callback("Mode " + mode + " doesn't exist!");
            exec(`cd /home/pi/LCD-show/ && sudo ./${command}`, function(error, stdout, stderr) {
                if (!error) console.log("Enabled mode '${mode}' successfully");
                callback(error);
            })
        })
    };

    var _disable = function(callback) {
		exec(`cd /home/pi/LCD-show/ && sudo ./system_restore.sh`, function(error, stdout, stderr) {
			if (!error) console.log("Disabled LCD-show successfully");
			callback(error);
		})
    };

    var _is_installed = function(callback) {
        fs.pathExists('/home/pi/LCD-show/', callback);
    };

    var _is_enabled = function(callback) {
        fs.pathExists('/home/pi/LCD-show/.have_installed', callback);
    };

    var _get_modes = function(callback) {
		fs.pathExists('/home/pi/LCD-show/', function (error, exists) {
			if (error||!exists) return callback('LCD-show path does not exist');
			fs.readdir('/home/pi/LCD-show/', function (error, files) {
				var modes = ['LCD-hdmi'];
				if (error) console.log('Unable to scan LCD-show dir: ' + error);
				if (files) {
					files.forEach(function(filename) {
						if(filename.match(/[\w]-show$/)) {
							modes.push(filename.replace('-show',''));
						}
					});
				}
				return callback(error,modes);
			});
		});
    };

    return {
        install:                    _install,
        enable:                     _enable,
        disable:                    _disable,
        is_installed:               _is_installed,
        is_enabled:                 _is_enabled,
        get_modes:               	_get_modes,
    };
}
