angular.module("openslides", [])
	.controller("openslides", ["openslides", "$scope", "$location", "$interval",

    function(openslides, $scope, $location, $interval) {

        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;
        $scope.port                   = 9000;

        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            openslides.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("OpenSlides installiert: " + response.data.result);
					if (response.data.result) {
						$scope.status = "installed";
					} else {
						$scope.status = false;
					}
                } else {
                    $scope.status = false;
                }
            });
        }

        $scope.install = function() {
            $scope.status = "installing";
            openslides.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("OpenSlides installiert: "+response.data.result);
                    $scope.status = "installed";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.start = function() {
            $scope.status = "starting";
            openslides.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("OpenSlides gestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.stop = function() {
            $scope.status = "stopping";
            openslides.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("OpenSlides gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.restart = function() {
            $scope.status = "restarting";
            openslides.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("OpenSlides neugestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "restarted";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            openslides.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("OpenSlides aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            openslides.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("OpenSlides deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.set_port = function() {
            openslides.set_port({port:$scope.port}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("OpenSlides Port geändert: " + response.data.result);
                }
            });
        }

        $scope.get_port = function() {
            openslides.get_port().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.port = response.data.port;
                }
            });
        }

        $scope.is_enabled = function() {
            openslides.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            openslides.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.is_installed();
        $scope.is_enabled();
        $scope.is_active();
        $scope.get_port();
        $interval(function() {
            $scope.is_installed();
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);