"use strict";

angular.module("openslides", [])
    .service("openslides", ["$http", "$location",

    function($http, $location) {
        return {

            is_installed: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/is_installed");
            },
            install: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/install");
            },
            start: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/start");
            },
            stop: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/stop");
            },
            restart: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/restart");
            },
            enable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/enable");
            },
            disable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/disable");
            },
            set_port: function(port, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.put("http://" + hostname + ":4242/api/openslides/port", port);
            },
            get_port: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/port");
            },
            is_active: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/is_active");
            },
            is_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/openslides/is_enabled");
            },

        };
    }]

);
