function updateStreamstatus(streamname) {
    $.getJSON('/api/v1/info.php?name='+streamname)
        .done(function( data ) {
            var health = '';
            // data.meta.video.frame_rate
            if ( data.stream.publishing ) {
                if ( data.stream.meta.video.height >= 1080 ) {
                    if ( data.stream.meta.video.frame_rate >= 60 ) {
                        var good = 6000000;
                        var ok = 4500000;
                    } else {
                        var good = 4500000;
                        var ok = 3000000;
                    }
                } else if ( data.stream.meta.video.height >= 720 ) {
                    if ( data.stream.meta.video.frame_rate >= 60 ) {
                        var good = 3750000;
                        var ok = 2250000;
                    } else {
                        var good = 2500000;
                        var ok = 1500000;
                    }
                } else if ( data.stream.meta.video.height >= 480 ) {
                    var good = 1000000;
                    var ok = 500000;
                } else if ( data.stream.meta.video.height >= 480 ) {
                    var good = 700000;
                    var ok = 400000;
                } else {
                    var good = 500000;
                    var ok = 300000;
                }
                if ( data.stream.bw_in >= good ) {
                    var health = 'good';
                } else if ( data.stream.bw_in < good && data.stream.bw_in >= ok ) {
                    var health = 'ok';
                } else if ( data.stream.bw_in < ok && data.stream.bw_in > 0 ) {
                    var health = 'bad';
                } else {
                    var health = 'no-data';
                }
                $('.status-bar').attr('data-health', health);
                $('.status-bar').attr('data-status', 'L');
                $('.status-bar .status-bar-component-content > h3').text(data.name);
                var bw_video = (new Intl.NumberFormat().format(parseInt((data.stream.bw_video)/1000)));
                $('.status-bar .video .bw').text(bw_video+' Kbps');
                $('.status-bar .video .height').text(parseInt(data.stream.meta.video.height));
                $('.status-bar .video .width').text(parseInt(data.stream.meta.video.width));
                $('.status-bar .video .frame_rate').text(parseInt(data.stream.meta.video.frame_rate));
                $('.status-bar .video .codec').text(data.stream.meta.video.codec);
                var bw_audio = (new Intl.NumberFormat().format(parseInt((data.stream.bw_audio)/1000)));
                $('.status-bar .audio .bw').text(bw_audio+' Kbps');
                var sample_rate = (new Intl.NumberFormat().format(data.stream.meta.audio.sample_rate));
                $('.status-bar .audio .sample_rate').text(sample_rate);
                $('.status-bar .audio .codec').text(data.stream.meta.audio.codec);
                $('.status-bar .audio .channels').text(parseInt(data.stream.meta.audio.channels));
                $('input[name=ClearKey]').prop("disabled", true);
                $('.btn-download').attr("disabled", true);
                $('.btn-download').removeAttr("href");
            } else {
                $('.status-bar').attr('data-health', 'offline');
                $('.status-bar').attr('data-status', 'O');
                $('.status-bar .status-bar-component-content > h3').text(data.name);
                $('.status-bar .video .bw').text('N/A');
                $('.status-bar .video .height').text('N/A');
                $('.status-bar .video .width').text('N/A');
                $('.status-bar .video .frame_rate').text('N/A');
                $('.status-bar .video .codec').text('N/A');
                $('.status-bar .audio .bw').text('N/A');
                $('.status-bar .audio .sample_rate').text('N/A');
                $('.status-bar .audio .codec').text('N/A');
                $('.status-bar .audio .channels').text('N/A');
                $('input[name=ClearKey]').prop("disabled", false);
                $('.btn-download').attr("disabled", false);
                $('.btn-download').attr("href","/rec/"+streamname+".flv");
            }
        })
        .fail(function( data ) {
            $('.status-bar').attr('data-health', 'offline');
            $('.status-bar').attr('data-status', 'O');
            $('.status-bar .video .bw').text('N/A');
            $('.status-bar .video .height').text('N/A');
            $('.status-bar .video .width').text('N/A');
            $('.status-bar .video .frame_rate').text('N/A');
            $('.status-bar .video .codec').text('N/A');
            $('.status-bar .audio .bw').text('N/A');
            $('.status-bar .audio .sample_rate').text('N/A');
            $('.status-bar .audio .codec').text('N/A');
            $('.status-bar .audio .channels').text('N/A');
            $('input[name=ClearKey]').prop("disabled", false);
            $('.btn-download').attr("disabled", false);
            $('.btn-download').attr("href","/rec/"+streamname+".flv");
        });
}
function updateClock () {
    var currentTime = new Date ( );
    var currentHours = currentTime.getHours ( );
    var currentMinutes = currentTime.getMinutes ( );
    var currentSeconds = currentTime.getSeconds ( );
    var currentYear = currentTime.getYear( );
    var currentMonth = currentTime.getMonth( ) + 1;
    var currentDay = currentTime.getDate( );
    currentYear = ( currentYear < 1000 ? currentYear+1900 : currentYear );
    // Pad the minutes and seconds with leading zeros, if required
    currentHours = ( currentHours < 10 ? "0" : "" ) + currentHours;
    currentMinutes = ( currentMinutes < 10 ? "0" : "" ) + currentMinutes;
    currentSeconds = ( currentSeconds < 10 ? "0" : "" ) + currentSeconds;
    currentYear = ( currentYear < 10 ? "0" : "" ) + currentYear;
    currentMonth = ( currentMonth < 10 ? "0" : "" ) + currentMonth;
    currentDay = ( currentDay < 10 ? "0" : "" ) + currentDay;
    // Compose the string for display
    var currentTimeString = currentHours + ":" + currentMinutes + ":" + currentSeconds;
    var currentDateString = currentDay + "." + currentMonth + "." + currentYear;
    // Update the time display
    $("#time").text(currentTimeString);
    $("#date").text(currentDateString);
}

function updateServiceUrl() {
    var val = $('select[name=service').val();
    if (val == "YouTube") {
        $('.alert')
            .parent().hide();
        $('input[name=url]')
            .attr('value','rtmp://a.rtmp.youtube.com/live2')
            .prop('readonly', true)
            .parent().show();;
        $('input[name=host]')
            .hide();
        $('input[name=app]')
            .hide();
    } else if (val == "Facebook") {
        $('.alert')
            .css('margin-bottom','0px')
            .parent().show();
        $('input[name=url]')
            .attr('value','rtmp://rtmp-api.facebook.com:80/rtmp')
            .prop('readonly', true)
            .parent().show();;
        $('input[name=host]')
            .hide();
        $('input[name=app]')
            .hide();
    } else if (val == "Twitch") {
        $('.alert')
            .parent().hide();
        $('input[name=url]')
            .attr('value','rtmp://live.twitch.tv/app')
            .prop('readonly', true)
            .parent().show();;
        $('input[name=host]')
            .hide();
        $('input[name=app]')
            .hide();
    } else if (val == "Periscope") {
        $('.alert')
            .parent().hide();
        $('input[name=url]')
            .parent().hide();
        $('input[name=host]')
            .attr('value','rtmp://de.pscp.tv:80/x/')
            .show();
        $('input[name=app]')
            .show();
    } else if (val == "Custom") {
        $('.alert')
            .parent().hide();
        $('input[name=url]')
//			.attr('value','')
            .prop('readonly', false)
            .parent().show();
        $('input[name=host]')
            .hide();
        $('input[name=app]')
            .hide();
    }
}
function getDateString (date) {
    var dateString = date.getFullYear() + '-' +
        (date.getMonth() + 1 < 10 ? '0' : '') +
        (date.getMonth() + 1) + '-' +
        (date.getDate() < 10 ? '0' : '') + date.getDate();
    return dateString;
}
function parseDateString ( dateString ) {
    var bits = dateString.split(/\D/);
    var date = new Date(bits[0], bits[1], bits[2], bits[3], bits[4]);
    return date;
}
function getIntegerArray ( start, end ) {
    var array = [];
    for (var i = start; i <= end; i++) {
        array.push( i );
    }
    return array;
}
function updateTimeFilter () {
    var datepickerElement = $('.datepicker');
    var datepicker = datepickerElement.data('Zebra_DatePicker');
    var selectedDate = datepickerElement.val();

    $('.timepicker').each(function(){
        var timepickerElement = $(this);
        var timepicker = timepickerElement.data('Zebra_DatePicker');
        var selectedTime = timepickerElement.val() ;

        var dateArray = selectedDate.split('.');
        var timeArray = selectedTime.split(':');
        dateArray[1] = dateArray[1] - 1;
        console.log("timeArray:",timeArray);

        var selectedDatetime = new Date(dateArray[2],dateArray[1],dateArray[0],timeArray[0],timeArray[0]);
        var selectedDateString = getDateString( selectedDatetime );
        console.log("selectedDatetime:",selectedDatetime);

        var nowDate = new Date();
        var nowDateString = getDateString( nowDate );

        console.log("selectedDateString:",selectedDateString);
        console.log("nowDateString:",nowDateString);
        console.log( "Heute:", selectedDateString === nowDateString );
        if ( selectedDateString === nowDateString ) {
            if ( selectedDatetime.getHours() < nowDate.getHours() ) {
                timepickerElement.val( nowDate.getHours() + ":" + selectedDatetime.getMinutes() );
            }
            var enabled_hours = getIntegerArray( nowDate.getHours(), 24 );
            console.log( "enabled_hours:", enabled_hours );
            timepicker.update({
                enabled_hours: enabled_hours
            });
            console.log( "Diese Stunde:", (selectedDatetime.getHours() === nowDate.getHours() ) );
            console.log( nowDate.getHours() );
            console.log( selectedDatetime.getHours() );
            if ( selectedDatetime.getHours() === nowDate.getHours() ) {
                if ( selectedDatetime.getMinutes() < nowDate.getMinutes() ) {
                    timepickerElement.val( selectedDatetime.getHours() + ":" + nowDate.getMinutes() );
                }
                var enabled_minutes = getIntegerArray( nowDate.getMinutes(), 59 );
                console.log( "enabled_minutes:", enabled_minutes );
                timepicker.update({
                    enabled_minutes: enabled_minutes
                });
            } else {
                var enabled_minutes = getIntegerArray( 0, 59 );
                console.log( "enabled_minutes:", enabled_minutes );
                timepicker.update({
                    enabled_minutes: enabled_minutes
                });
            }
        } else {
            var enabled_hours = getIntegerArray( 0, 24 );
            console.log( "enabled_hours:", enabled_hours );
            var enabled_minutes = getIntegerArray( 0, 59 );
            console.log( "enabled_minutes:", enabled_minutes );
            timepicker.update({
                enabled_hours: enabled_hours,
                enabled_minutes: enabled_minutes
            });
        }
    });
}