<?php

// save current IPs to config
function config_update_ips () {
    $config_new = [
        'ip_lan'  => get_ip("eth0"),
        'ip_wifi' => get_ip("wlan0")
    ];
    config_update( $config_new );
}

function config_update ( $new_config ) {
    $config = config_load();
    $config_new = array_merge($config, $new_config);
    return config_save( $config_new );
}

function config_save ( $config ) {
    $file = 'config.ini';
    $config_ini = arr2ini($config);
    return file_put_contents($file, $config_ini);
}

function config_load () {
    $file = 'config.ini';
    if ( !$config = parse_ini_file($file, TRUE) ) {
        $serial = get_serial();
        var_dump();
        $user_connecttoken = substr($serial,-5);
        $config = [
            'serial'  => "$serial",
            'user_connecttoken'  => "$user_connecttoken",
            'ip_lan'  => get_ip("eth0"),
            'ip_wifi' => get_ip("wlan0")
        ];
        if ( !config_save( $config ) ) {
            throw new exception('Unable to open ' . $file . '.');
        }
    }
    return $config;
}

function arr2ini(array $a, array $parent = array()) {
    $out = '';
    foreach ($a as $k => $v) {
        if (is_array($v)) {
            //subsection case
            //merge all the sections into one array...
            $sec = array_merge((array) $parent, (array) $k);
            //add section information to the output
            $out .= '[' . join('.', $sec) . ']' . PHP_EOL;
            //recursively traverse deeper
            $out .= arr2ini($v, $sec);
        } else {
            //plain key->value case
            $out .= "$k=\"$v\"" . PHP_EOL;
        }
    }
    return $out;
}

function get_ip($iface) {
    $command="/sbin/ifconfig $iface | grep 'inet ' | awk '{ print $2}'";
    return exec($command);
}
function get_serial() {
    $command="cat /proc/cpuinfo | grep 'Serial' | awk '{ print $3}'";
    return exec($command);
}

$config = config_load();
config_update_ips();
