function countdown() {
  var timeleft = 2;
  var downloadTimer = setInterval(function(){
    if(timeleft <= 0){
      clearInterval(downloadTimer);
      $("#countdown").html("Redirecting now");
    } else {
      $("#countdown").html("Redirecting in " + timeleft + " seconds");
    }
    timeleft -= 1;
  }, 1000);
};
function heartbeat() {
  var heartbeatTimer = setInterval(function(){
    $.post( "https://piraten.live/api/v1/device.php?action=heartbeat", { "serial": "<?=$config['serial'];?>", "authtoken": "<?=$config['user_authtoken'];?>" });
  }, 5000);
};
function auth(serial, user_connecttoken, callback) {
  $.post( "https://piraten.live/api/v1/device.php?action=auth", { "serial": serial, "connecttoken": user_connecttoken })
    .done(function( data ) {
      if ( data.status == 200 && data.result.authtoken ) {
        $.post( "/api.php", { 'setconfig': { "user_authtoken": data.result.authtoken, "user_id": data.result.user }} )
          .done(function() {
            callback();
            countdown();
            setTimeout(function(){window.location='/streams.php?checkonly'},3000);
            heartbeat();
          })
      } else {
        console.log("Not yet authenticated");
        setTimeout(function(){auth(serial, user_connecttoken, callback)},1000);
      }
    })
    .fail(function( data ) {
      console.log("Failed to call auth api");
      setTimeout(function(){auth(serial, user_connecttoken, callback)},1000);
    });
};
function isUpAgain(callback){
  $.post( "/api.php", { 'system': 'status'} )
    .done(function() {
      callback();
      countdown();
      setTimeout(function(){window.location='/'},3000);
    })
    .fail(function() {
      setTimeout(function(){
        isUpAgain(callback);
      }, 5000);
    });
};
