<?php
require_once('config.php');

$events_json = file_get_contents('https://piraten.live/api/v1/list.php?user=' . $config['user_id']);
$events = json_decode($events_json,true);

$stream_valid = false;
if ( isset($_GET['checkonly']) && !empty( $config['event_id'] ) && !empty( $config['event_key'] ) && count($events) > 0 ) {
	foreach ($events as $event) {
		if ( $event['id'] == $config['event_id'] ) {
			$stream_valid = true;
			header( "refresh:3;url=stream.php" );
			break;
		}
	}
}

include('tmpl/header.php');

if ($stream_valid) {
?>
				<h2>Stream configured</h2>
				<div id="countdown">Redirecting in 3 seconds</div>
<?php
} else {
?>
				<h2>Choose your stream</h2>
<?php
	if( count($events) > 0) {
?>      <table class="table table-hover events">
                <thead>
                        <tr>
                                <th>Event Name</th>
                                <th>Dates</th>
                        </tr>
                </thead>
                <tbody>
<?php

        foreach($events AS $event) {
                $dates = array();
                foreach($event['times'] AS $time) {
                        $dates[] = date_format(date_create_from_format('Y-m-d',$time["date"]),'d.m.Y');
                }
?>                      <tr data-event-id="<?=$event['id'];?>">
                                <td><?=$event["name"];?></td>
                                <td><?=join(', ',$dates);?></td>
                        </tr>
<?php
        }
?>              </tbody>
        </table>
		<script type="text/javascript" defer>
			$(document).ready(function(){
				$(".events tr").click(function() {
					event_id = $(this).data('event-id');
					console.log(event_id);
					$.post( "https://piraten.live/api/v1/list.php?id="+event_id, { "serial": "<?=$config['serial'];?>", "authtoken": "<?=$config['authtoken'];?>" })
						.done(function( data ) {
							if ( data && data [0] ) {
								event = data[0];
								$.post( "/api.php", { 'setconfig': { "event_id": event.id, "event_key": event.key }} )
									.done(function( data ) {
										window.location = '/stream.php';
									});
							}
						});
				});
				heartbeat();
			});
		</script>
<?php
	} else {
	        echo "Currently no events exists!<br />";
	        echo 'Create an event at Piraten.Live/admin/events/new</a><br />';
	}
}

include('tmpl/footer.php');
