angular.module("rpi_touch_driver", [])
	.controller("rpi_touch_driver", ["rpi_touch_driver", "$scope", "$location", "$interval",

    function(rpi_touch_driver, $scope, $location, $interval) {

        $scope.status                 = false;
        $scope.installed              = false;
        $scope.enabled                = false;
        $scope.active                 = false;

        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            rpi_touch_driver.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("rpi_touch_driver installiert: " + response.data.result);
					if (response.data.result) {
						$scope.status = "installed";
						$scope.installed = true;
					} else {
						$scope.installed = false;
						$scope.status = false;
					}
                } else {
					$scope.installed = false;
                    $scope.status = false;
                }
            });
        }

        $scope.install = function() {
            $scope.status = "installing";
            rpi_touch_driver.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("rpi_touch_driver installiert: "+response.data.result);
                    $scope.status = "installed";
					$scope.installed = true;
                } else {
                    $scope.status = "failed";
					$scope.installed = false;
                }
            });
        }

        $scope.start = function() {
            $scope.status = "starting";
            rpi_touch_driver.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("rpi_touch_driver gestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.stop = function() {
            $scope.status = "stopping";
            rpi_touch_driver.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("rpi_touch_driver gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.restart = function() {
            $scope.status = "restarting";
            rpi_touch_driver.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("rpi_touch_driver neugestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "restarted";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            rpi_touch_driver.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("rpi_touch_driver aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            rpi_touch_driver.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("rpi_touch_driver deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.is_enabled = function() {
            rpi_touch_driver.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            rpi_touch_driver.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.is_installed();
        $scope.is_enabled();
        $scope.is_active();
        $interval(function() {
            $scope.is_installed();
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);