var express           = require('express'),
    router            = express.Router(),
    fs                = require("fs-extra"),
    screenstream      = require("app/modules/screenstream")(),
    helper            = require("app/core/helper");

router.route("/view/config.html")
	.get(function(request, response) {
		fs.readFile('./app/modules/screenstream/views/config.html', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/services/screenstream.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/screenstream/services/screenstream.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/controller/screenstream.js")
	.get(function(request, response) {
		fs.readFile('./app/modules/screenstream/controller/screenstream.js', function (error, template) {
		    if (error) response.send(error);
			else response.send(template);
		});
	});

router.route("/install")
	.post(function(request, response) {
		screenstream.install(function(error) {
			console.log("Installed ScreenStream: " + (!error));
			helper.apiAnswer({result:"ScreenStream installed"},error,response);
		});
	});

router.route("/start")
	.get(function(request, response) {
		screenstream.start(function(error) {
			console.log("Started ScreenStream: " + (!error));
			helper.apiAnswer({result:"ScreenStream started"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		screenstream.stop(function(error) {
			console.log("Stopped ScreenStream: " + (!error));
			helper.apiAnswer({result:"ScreenStream stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		screenstream.restart(function(error) {
			console.log("Restarted ScreenStream: " + (!error));
			helper.apiAnswer({result:"ScreenStream restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		screenstream.enable(function(error) {
			console.log("Enabled ScreenStream: " + (!error));
			helper.apiAnswer({result:"ScreenStream enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		screenstream.disable(function(error) {
			console.log("Disabled ScreenStream: " + (!error));
			helper.apiAnswer({result:"ScreenStream disabled"},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		screenstream.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		screenstream.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		screenstream.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

module.exports = router;
