angular.module("screenstream", [])
	.controller("screenstream", ["screenstream", "$scope", "$location", "$interval", "$timeout",

    function(screenstream, $scope, $location, $interval, $timeout) {

        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;

        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            screenstream.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk installiert: " + response.data.result);
					if (response.data.result) {
						$scope.status = "installed";
					} else {
						$scope.status = false;
					}
                } else {
                    $scope.status = false;
                }
            });
        }

        $scope.install = function() {
            $scope.status = "installing";
            screenstream.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk installiert: "+response.data.result);
                    $scope.status = "installed";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.start = function() {
            $scope.status = "starting";
            screenstream.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk gestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                    $scope.load_video();
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.stop = function() {
            $scope.status = "stopping";
            screenstream.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.restart = function() {
            $scope.status = "restarting";
            screenstream.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk neugestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "restarted";
                    $scope.load_video();
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            screenstream.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            screenstream.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.is_enabled = function() {
            screenstream.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            screenstream.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    if ( !$scope.active && response.data.result ) {
                        $scope.active = true;
                        $scope.load_video();
                    } else {
                        $scope.active = response.data.result;
                    }
                }
            });
        }

        $scope.load_video = function() {
            if ($scope.active) {
                $timeout(function() {
                    if (flvjs.isSupported()) {
                        var videoElement = document.getElementById('videoPlayer');
                        var hostname = $location.host();
                        if (flvPlayer == null) {
                            var flvPlayer = flvjs.createPlayer({
                                "type": 'flv',
                                "isLive": true,
                                "url": 'ws://' + hostname + ':3000/live/screen.flv'
                            });
                            flvPlayer.attachMediaElement(videoElement);
                        }
                        flvPlayer.load();
                        flvPlayer.play();
                        flvPlayer.on('error', function() {
                            flvPlayer.unload();
                            flvPlayer.detachMediaElement();
                            flvPlayer.load();
                            flvPlayer.play();
                        });
                    }
                }, 1000);
            }
        }


        $scope.is_installed();
        $scope.is_enabled();
        $scope.is_active();
        $interval(function() {
            $scope.is_installed();
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);