var async           = require("async"),
    fs              = require("fs-extra"),
    exec            = require("child_process").exec,
    systemctl       = require("systemctl-cmd"),
    config          = require("app/core/config")();

/*****************************************************************************\
    Return the config and a function which we can use to change config file
\*****************************************************************************/
module.exports = function() {

    var is_LXDE = false;

    var _install = function(callback) {
        async.waterfall([
            function create_service(next_step) {
                console.log('Create service...');
				exec(`sudo cp -f ` + config.root + `/assets/systemd/PiratenBox-ScreenStream.service /etc/systemd/system/PiratenBox-ScreenStream.service`, function(error) {
					if (!error) console.log("Service created successfully...");
					next_step(error);
				});
            },
            function reload_services(next_step) {
                console.log('Reload services...');
                systemctl.daemonReload(true).then(function(result) {
                    if (!result.error) console.log("Services reloaded successfully...");
                    next_step(result.error);
                });
            },
            function save_config(next_step) {
                console.log('Saving config...');
	            config.load(function(error,config) {
	                if (error) return callback(error);
	                if (!config.modules) config.modules = {};
	                config.modules.screenstream = true;
	                if (!config.screenstream) config.screenstream = {};
	                config.screenstream.installed = true;
	                config.save(config, function(error) {
	                    if (!error) console.log(`Saved config successfully`);
	                    callback(error);
	                });
	            });
            },
        ], callback);
    };

    var _enable = function(callback) {
        console.log('Enable service...');
        systemctl.enable('PiratenBox-ScreenStream',true).then(result => {
            if (!result.error) console.log("Service enabled successfully...");
            callback(result.error);
        })
    };

    var _disable = function(callback) {
        console.log('Disable service...');
        systemctl.disable('PiratenBox-ScreenStream',true).then(result => {
            if (!result.error) console.log("Service disabled successfully...");
            callback(result.error);
        })
    };

    var _start = function(callback) {
        console.log('Start service...');
        systemctl.start('PiratenBox-ScreenStream',true).then(result => {
            if (result.error) callback(result.error)
            else {
                console.log("Service started successfully...");
                callback();
            }
        })
    };

    var _stop = function(callback) {
        console.log('Stop service...');
        systemctl.stop('PiratenBox-ScreenStream',true).then(result => {
            if (!result.error) console.log("Service stopped successfully...");
            callback(result.error);
        })
    };

    var _restart = function(callback) {
        console.log('Restarting service...');
        systemctl.restart('PiratenBox-ScreenStream',true).then(result => {
            if (result.error) callback(result.error)
            else {
                console.log("Service restarted successfully...");
                callback();
            }
        })
    };

    var _is_installed = function(callback) {
        fs.pathExists('/etc/systemd/system/PiratenBox-ScreenStream.service', callback);
    };

    var _is_enabled = function(callback) {
        systemctl.isEnabled('PiratenBox-ScreenStream').then(enabled => {
            callback(null, enabled);
//            console.log((enabled ? 'Enabled' : 'Not enabled'));
        }, error => {
            callback(error);
        })
    };

    var _is_active = function(callback) {
        systemctl.isActive('PiratenBox-ScreenStream').then(active => {
            callback(null, active);
//            console.log((active ? 'Active' : 'Not active'));
        }, error => {
            callback(error);
        })
    };

    return {
        install:                    _install,
        enable:                     _enable,
        disable:                    _disable,
        start:                      _start,
        stop:                       _stop,
        restart:                    _restart,
        is_installed:               _is_installed,
        is_enabled:                 _is_enabled,
        is_active:                  _is_active,
    };
}
