angular.module("vnc", ['noVNC'])
	.controller("vnc", ["vnc", "$scope", "$interval",

	function(vnc, $scope, $interval) {

		$scope.connections            = [];
        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;
        $scope.port                   = 5900;
        $scope.passwd                 = '';

		$scope.add_connection = function () {
			$scope.connections.push({});
		}

		$scope.remove_connection = function (index) {
			$scope.connections.splice(index, 1);
		}

        $scope.is_installed = function() {
            if ($scope.status=='installing') return;
            vnc.is_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC installiert: " + response.data.result);
					if (response.data.result) {
						$scope.status = "installed";
					} else {
						$scope.status = false;
					}
                } else {
                    $scope.status = false;
                }
            });
        }

        $scope.install = function() {
            $scope.status = "installing";
            vnc.install().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC installiert: "+response.data.result);
                    $scope.status = "installed";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.start = function() {
            $scope.status = "starting";
            vnc.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC gestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.stop = function() {
            $scope.status = "stopping";
            vnc.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.restart = function() {
            $scope.status = "restarting";
            vnc.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC neugestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "restarted";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            vnc.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            vnc.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.set_port = function() {
            vnc.set_port({port:$scope.port}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC Port geändert: " + response.data.result);
                }
            });
        }

        $scope.get_port = function() {
            vnc.get_port().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.port = response.data.port;
                }
            });
        }

        $scope.set_passwd = function() {
            vnc.set_passwd({passwd:$scope.passwd}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("VNC Passwort geändert: " + response.data.result);
                }
            });
        }

        $scope.get_passwd = function() {
            vnc.get_passwd().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.passwd = response.data.passwd;
                }
            });
        }

        $scope.is_enabled = function() {
            vnc.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            vnc.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.is_installed();
        $scope.is_enabled();
        $scope.is_active();
        $scope.get_port();
        $scope.get_passwd();
        $interval(function() {
            $scope.is_installed();
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

	}

]);
