"use strict";

angular.module("vnc", [])
    .service("vnc", ["$http", "$location",

    function($http, $location) {
        return {

            is_installed: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/is_installed");
            },
            install: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/install");
            },
            start: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/start");
            },
            stop: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/stop");
            },
            restart: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/restart");
            },
            enable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/enable");
            },
            disable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/disable");
            },
            set_port: function(port, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.put("http://" + hostname + ":4242/api/vnc/port", port);
            },
            get_port: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/port");
            },
            set_passwd: function(passwd, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.put("http://" + hostname + ":4242/api/vnc/passwd", passwd);
            },
            get_passwd: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/passwd");
            },
            is_active: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/is_active");
            },
            is_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/vnc/is_enabled");
            },

        };
    }]

);
