app.controller("bluetooth", ["bluetooth", "$scope", "$location", "$interval",

    function(bluetooth, $scope, $location, $interval) {
        // Scope variable declaration
        $scope.bluetooth                 = {};
        $scope.show_connect    = false;
        $scope.show_info       = {'show':false};
        $scope.show_list       = false;

        // Scope filter definitions
        $scope.orderScanResults = function(device) {
            return parseInt(device.signal);
        }

        // Scope function definitions
        $scope.block = function() {
            bluetooth.block().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Bluetooth blocked");
                    $scope.bluetooth.blocked = true;
                }
            });
        }
        $scope.unblock = function() {
            bluetooth.unblock().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Bluetooth unblocked");
                    $scope.bluetooth.blocked = false;
                }
            });
        }
        $scope.is_blocked = function() {
            bluetooth.is_blocked().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.blocked = response.data.result;
                }
            });
        }

        $scope.enable = function() {
            bluetooth.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Bluetooth enabled");
                    $scope.bluetooth.enabled = true;
                }
            });
        }
        $scope.disable = function() {
            bluetooth.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Bluetooth disabled");
                    $scope.bluetooth.enabled = false;
                }
            });
        }
        $scope.is_enabled = function() {
            bluetooth.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.enabled = response.data.result;
                }
            });
        }

        $scope.start = function() {
            bluetooth.start().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Bluetooth started");
                    $scope.bluetooth.active = true;
                }
            });
        }
        $scope.stop = function() {
            bluetooth.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Bluetooth stopped");
                    $scope.bluetooth.active = false;
                }
            });
        }
        $scope.is_active = function() {
            bluetooth.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.active = response.data.result;
                }
            });
        }

        $scope.is_available = function() {
            bluetooth.is_available().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.available = response.data.result;
                }
            });
        }

        $scope.is_ready = function() {
            bluetooth.is_ready().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.ready = response.data.result;
                }
            });
        }

        $scope.is_discoverable = function() {
            bluetooth.is_discoverable().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.discoverable = response.data.result;
                }
            });
        }
        $scope.toggle_discoverable = function() {
            bluetooth.set_discoverable( !$scope.bluetooth.discoverable )
				.then(function(response) {
					$scope.is_discoverable();
				});
        }

        $scope.is_powered = function() {
            bluetooth.is_powered().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.powered = response.data.result;
                }
            });
        }
        $scope.toggle_powered = function() {
            bluetooth.set_powered( !$scope.bluetooth.powered )
				.then(function(response) {
					$scope.is_powered();
				});
        }
        $scope.reset = function() {
			$scope.bluetooth.enabled = false;
            bluetooth.reset().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Bluetooth rebooted");
					$scope.is_powered();
                }
            });
        }

        $scope.is_pairable = function() {
            bluetooth.is_pairable().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.pairable = response.data.result;
                }
            });
        }
        $scope.toggle_pairable = function() {
            bluetooth.set_pairable( !$scope.bluetooth.pairable )
				.then(function(response) {
					$scope.is_pairable();
				});
        }

        $scope.is_scanning = function() {
            bluetooth.is_scanning().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.scanning = response.data.result;
                }
            });
        }
        $scope.start_scanning = function() {
            bluetooth.set_scanning( true )
				.then(function(response) {
					$scope.is_scanning();
				});
        }
        $scope.stop_scanning = function() {
            bluetooth.set_scanning( false )
				.then(function(response) {
					$scope.is_scanning();
				});
        }
        $scope.toggle_scanning = function() {
            bluetooth.set_scanning( !$scope.bluetooth.scanning )
				.then(function(response) {
					$scope.is_scanning();
				});
        }

        $scope.pair = function(mac) {
            bluetooth.pair(mac).then(function(response) {
                if (response.data.status == "SUCCESS") {
//					$scope.get_paired_devices();
                }
            });
        }
        $scope.unpair = function(mac) {
            bluetooth.unpair(mac).then(function(response) {
                if (response.data.status == "SUCCESS") {
//					$scope.get_paired_devices();
                }
            });
        }
        $scope.is_confirming = function() {
            bluetooth.is_confirming().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.confirming = response.data.result;
                }
            });
        }
        $scope.is_waiting_for_pin = function() {
            bluetooth.is_waiting_for_pin().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.waiting_for_pin = response.data.result;
                }
            });
        }
        $scope.get_pin = function() {
            bluetooth.get_pin().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.pin = response.data.result;
                }
            });
        }


        $scope.connect = function(mac) {
            bluetooth.connect(mac).then(function(response) {
                if (response.data.status == "SUCCESS") {
//					$scope.show_connect = false;
                }
            });
        }
        $scope.disconnect = function(mac) {
            bluetooth.disconnect(mac).then(function(response) {
                if (response.data.status == "SUCCESS") {
//					$scope.show_connect = false;
                }
            });
        }


        $scope.get_controllers = function() {
            bluetooth.get_controllers().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.controllers = response.data.result;
                }
            });
        }

        $scope.get_scanned_devices = function() {
            bluetooth.get_scanned_devices().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.scanned_devices = response.data.result;
                }
            });
        }

        $scope.get_paired_devices = function() {
            bluetooth.get_paired_devices().then(function(response) {
                if (response.data.status == "SUCCESS") {
					$scope.bluetooth.paired_devices = response.data.result;
                }
            });
        }

        $scope.info = function(device) {
			$scope.show_info.device = device;
			$scope.show_info.view = true;
        }

        // Defer load the states and infos
        $scope.is_blocked();
        $scope.is_enabled();
        $scope.is_active();
        $scope.is_available();
        $scope.is_ready();
        $scope.is_discoverable();
        $scope.is_powered();
        $scope.is_pairable();
        $scope.is_scanning();
        $scope.is_confirming();
		$scope.is_waiting_for_pin();
        $scope.get_pin();
        $scope.get_controllers();
        $scope.get_scanned_devices();
        $scope.get_paired_devices();
        $interval(function() {
			$scope.is_blocked();
			$scope.is_enabled();
			$scope.is_active();
			$scope.is_available();
			$scope.is_ready();
			$scope.is_discoverable();
			$scope.is_powered();
			$scope.is_pairable();
			$scope.is_scanning();
			$scope.is_confirming();
			$scope.is_waiting_for_pin();
			$scope.get_pin();
			$scope.get_controllers();
			$scope.get_scanned_devices();
			$scope.get_paired_devices();
        }, 5000);

    }]
);
