app.controller("ControlpanelController", ["core", "system", "$scope", "$http", "$route", "$routeParams", "$location", "$timeout", "$interval", "$compile", "$controller", "$ocLazyLoad",

    function(core, system, $scope, $http, $route, $routeParams, $location, $timeout, $interval, $compile, $controller, $ocLazyLoad) {
        // Scope variable declaration
	$scope.$route                    = $route;
	$scope.$location                 = $location;
	$scope.$routeParams              = $routeParams;
	// main view
        $scope.loading                   = false;
        $scope.loadfail                  = false;
        $scope.current_page              = "welcome";
        $scope.current_host              = $location.host();
        $scope.infos                     = {};
        $scope.temperature               = 0;
        $scope.modules                   = {available:{},installed:[]};
        // open in kiosk
        $scope.kiosk_url                 = false;


        $scope.get_infos = function() {
            core.get_infos().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log('infos', response.data.infos);
		    $scope.infos = response.data.infos;
                }
            });
        }

        $scope.get_modules_available = function() {
            core.get_modules_available().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log('modules available', response.data.available);
                    $scope.modules.available = response.data.available;
                }
            });
        }

        $scope.get_modules_installed = function() {
            core.get_modules_installed().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log('modules installed', response.data.installed);
                    $scope.modules.installed = response.data.installed;
                }
            });
        }

        $scope.get_temperature = function() {
            system.get_temperature().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log('get_temperature', response.data.temperature);
                    $scope.temperature = response.data.temperature;
                }
            });
        }

        $scope.open_in_kiosk = function(url) {
/*
 *          TODO: Change to new instance sheme or remove
 * 
	    kiosk.change_url({url:url}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Kiosk URL geändert: " + response.data.result);
                }
            });
*/
        }

        $scope.change_tab = function(tab) {
			$scope.current_page = tab;
        }

        $scope.loadController = function(module, controller, container) {
			var content = $(container).html();
			content = '<div id="' + controller + '" ng-controller="' + controller + '">' + content + '</div>';
			$(container).html(content);
			$ocLazyLoad.load('/api/' + module + '/services/' + controller + '.js').then(function(){
				$ocLazyLoad.load('/api/' + module + '/controller/' + controller + '.js').then(function(){
					var moduleScope = $scope.$new();
					$controller(controller,{$scope:moduleScope});
					$compile($('#'+controller))(moduleScope);
					$timeout(function() {
						$scope.loading = false;
					}, 600);
				});
			});
        }

        $scope.loadModulePage = function(module,page) {
			$scope.loading = true;
			$scope.current_page = module;
			$http.get('/api/' + module + '/view/' + page + '.html').then(function(result) {
				$scope.loadfail = false;
				$('#module-container').html(result.data);
				$scope.loadController(module,module,'#module-container');
			}, function(result) {
				$scope.loadfail = true;
				$scope.loading = false;
			});
		};

        $scope.loadModuleConfig = function(module) {
			$scope.loadModulePage(module,'config');
		};

        $scope.loadCorePage = function(page) {
			$scope.loading = true;
			$scope.current_page = page;
			$scope.loadfail = false;
			$scope.loading = false;
		};


        // Defer load the states and infos
        $scope.get_modules_available();
        $scope.get_modules_installed();
        $scope.get_infos();
        $scope.get_temperature();
        $interval(function() {
            $scope.get_modules_installed();
	    $scope.get_infos();
	    $scope.get_temperature();
        }, 5000);

    }]
);
