app.controller("modules", ["core", "$scope", "$location", "$http",

    function(core, $scope, $location, $http) {

		$scope.is_installing = false;

        $scope.install = function(module) {
			$scope.is_installing = true;
			$scope.modules.available[module].status = "installing";
			var url = "http://" + $location.host() + ":4242/api/" + module + "/install";
			$http.post(url, {})
				.then(function(response) {
					$scope.is_installing = false;
					if (response.data.status == "SUCCESS") {
						console.log(module + " installiert: " + response.data.result);
						$scope.modules.available[module].status = "installed";
					} else {
						$scope.modules.available[module].status = "failed";
					}
				});
        }

    }]
);
